% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_aks_methods.R
\name{get_aks}
\alias{get_aks}
\alias{list_aks}
\title{Get Azure Kubernetes Service (AKS)}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{get_aks(name)
list_aks()
}
}

\section{Arguments}{

\itemize{
\item \code{name}: For \code{get_aks()}, the name of the Kubernetes service.
}
}

\section{Details}{

The \code{AzureRMR::az_resource_group} class has both \code{get_aks()} and \code{list_aks()} methods, while the \code{AzureRMR::az_subscription} class only has the latter.
}

\section{Value}{

For \code{get_aks()}, an object of class \code{az_kubernetes_service} representing the service.

For \code{list_aks()}, a list of such objects.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$get_aks("mycluster")

}
}
\seealso{
\link{create_aks}, \link{delete_aks}

\link{az_kubernetes_service}

\link{kubernetes_cluster} for the cluster endpoint

\href{https://docs.microsoft.com/en-us/azure/aks/}{AKS documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/aks/}{API reference}

\href{https://kubernetes.io/docs/reference/}{Kubernetes reference}
}
