% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AzureToken.R
\name{get_azure_token}
\alias{get_azure_token}
\title{Generate an Azure OAuth token}
\usage{
get_azure_token(aad_host, tenant, app,
  auth_type = c("client_credentials", "device_code"), password,
  resource_host)
}
\arguments{
\item{aad_host}{URL for your Azure Active Directory host. For the public Azure cloud, this is \code{https://login.microsoftonline.com/}.}

\item{tenant}{Your tenant ID.}

\item{app}{Your client/app ID which you registered in AAD.}

\item{auth_type}{The authentication type, either \code{"client_credentials"} or \code{"device_code"}.}

\item{password}{Your password. Required for \code{auth_type == "client_credentials"}, ignored for \code{auth_type == "device_code"}.}

\item{resource_host}{URL for your resource host. For Resource Manager in the public Azure cloud, this is \code{https://management.azure.com/}.}
}
\description{
This extends the OAuth functionality in httr to allow for device code authentication.
}
\details{
This function does much the same thing as \code{\link[httr:oauth2.0_token]{httr::oauth2.0_token()}}, but with support for device authentication and with unnecessary options removed. Device authentication removes the need to save a password on your machine. Instead, the server provides you with a code, along with a URL. You then visit the URL in your browser and enter the code, which completes the authentication process.
}
\examples{
\dontrun{

token <- get_azure_token(
   aad_host="https://login.microsoftonline.com/",
   tenant="myaadtenant.onmicrosoft.com",
   app="app_id",
   password="password",
   resource_host="https://management.azure.com/")

}
}
\seealso{
\link{AzureToken}, \link[httr:oauth2.0_token]{httr::oauth2.0_token}, \link[httr:Token]{httr::Token},
\href{https://docs.microsoft.com/en-us/azure/active-directory/develop/active-directory-protocols-oauth-code}{OAuth authentication for Azure Active Directory},
\href{https://www.oauth.com/oauth2-servers/device-flow/token-request/}{Device code flow on OAuth.com}
}
