% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{named_list}
\alias{named_list}
\alias{is_url}
\alias{is_empty}
\title{Miscellaneous utility functions}
\usage{
named_list(lst, name_fields = "name")

is_url(x, https_only = FALSE)

is_empty(x)
}
\arguments{
\item{lst}{A named list of objects.}

\item{name_fields}{The components of the objects in \code{lst}, to be used as names.}

\item{x}{For \code{is_url} and \code{is_empty}, An R object.}

\item{https_only}{For \code{is_url}, whether to allow only HTTPS URLs.}
}
\value{
For \code{named_list}, the list that was passed in but with names. For \code{is_url}, whether the object appears to be a URL (is character of length 1, and starts with the string \code{"http"}). Optionally, restricts the check to HTTPS URLs only. For \code{is_empty}, whether the length of the object is zero (this includes the special case of \code{NULL}).
}
\description{
Miscellaneous utility functions
}
\details{
\code{named_list} extracts from each object in \code{lst}, the components named by \code{name_fields}. It then constructs names for \code{lst} from these components, separated by a \code{"/"}.
}
