% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer_generics.R
\name{storage_upload}
\alias{storage_upload}
\alias{storage_upload.blob_container}
\alias{storage_upload.file_share}
\alias{storage_upload.adls_filesystem}
\alias{storage_multiupload}
\alias{storage_multiupload.blob_container}
\alias{storage_multiupload.file_share}
\alias{storage_multiupload.adls_filesystem}
\alias{storage_download}
\alias{storage_download.blob_container}
\alias{storage_download.file_share}
\alias{storage_download.adls_filesystem}
\alias{storage_multidownload}
\alias{storage_multidownload.blob_container}
\alias{storage_multidownload.file_share}
\alias{storage_multidownload.adls_filesystem}
\alias{download_from_url}
\alias{upload_to_url}
\title{Upload and download generics}
\usage{
storage_upload(container, ...)

\method{storage_upload}{blob_container}(container, src, dest, ...)

\method{storage_upload}{file_share}(container, src, dest, ...)

\method{storage_upload}{adls_filesystem}(container, src, dest, ...)

storage_multiupload(container, ...)

\method{storage_multiupload}{blob_container}(container, src, dest, ...)

\method{storage_multiupload}{file_share}(container, src, dest, ...)

\method{storage_multiupload}{adls_filesystem}(container, src, dest, ...)

storage_download(container, ...)

\method{storage_download}{blob_container}(container, src, dest, ...)

\method{storage_download}{file_share}(container, src, dest, ...)

\method{storage_download}{adls_filesystem}(container, src, dest, ...)

storage_multidownload(container, ...)

\method{storage_multidownload}{blob_container}(container, src, dest, ...)

\method{storage_multidownload}{file_share}(container, src, dest, ...)

\method{storage_multidownload}{adls_filesystem}(container, src, dest, ...)

download_from_url(src, dest, key = NULL, token = NULL, sas = NULL,
  ..., overwrite = FALSE)

upload_to_url(src, dest, key = NULL, token = NULL, sas = NULL, ...)
}
\arguments{
\item{container}{A storage container object.}

\item{...}{Further arguments to pass to lower-level functions.}

\item{src, dest}{The source and destination files to transfer.}

\item{key, token, sas}{Authentication arguments: an access key, Azure Active Directory (AAD) token or a shared access signature (SAS). If multiple arguments are supplied, a key takes priority over a token, which takes priority over a SAS. For \code{upload_to_url} and \code{download_to_url}, you can also provide a SAS as part of the URL itself.}

\item{overwrite}{For downloading, whether to overwrite any destination files that exist.}
}
\description{
Upload and download generics
}
\details{
These functions allow you to transfer files to and from a storage account.

\code{storage_upload}, \code{storage_download}, \code{storage_multiupload} and \code{storage_multidownload} take as first argument a storage container, either for blob storage, file storage, or ADLSgen2. They dispatch to the corresponding file transfer functions for the given storage type.

\code{upload_to_url} and \code{download_to_url} allow you to transfer a file to or from Azure storage, given the URL of the source or destination. The storage details (endpoint, container name, and so on) are obtained from the URL.

By default, \code{storage_download} and \code{download_from_url} will display a progress bar while they are downloading. To turn this off, use \code{options(azure_dl_progress_bar=FALSE)}. To turn the progress bar back on, use \code{options(azure_dl_progress_bar=TRUE)}.
}
\examples{
\dontrun{

# download from blob storage
bl <- storage_endpoint("https://mystorage.blob.core.windows.net/", key="access_key")
cont <- storage_container(bl, "mycontainer")
storage_download(cont, "bigfile.zip", "~/bigfile.zip")

# same download but directly from the URL
download_from_url("https://mystorage.blob.core.windows.net/mycontainer/bigfile.zip",
                  "~/bigfile.zip",
                  key="access_key")

# upload to ADLSgen2
ad <- storage_endpoint("https://myadls.dfs.core.windows.net/", token=mytoken)
cont <- storage_container(ad, "myfilesystem")
create_storage_dir(cont, "newdir")
storage_upload(cont, "files.zip", "newdir/files.zip")

# same upload but directly to the URL
upload_to_url("files.zip",
              "https://myadls.dfs.core.windows.net/myfilesystem/newdir/files.zip",
              token=mytoken)

}
}
\seealso{
\link{storage_container}, \link{blob_container}, \link{file_share}, \link{adls_filesystem}

\link{download_blob}, \link{download_azure_file}, \link{download_adls_file}, \link{call_azcopy}
}
