% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_vm_template.R
\docType{class}
\name{az_vm_template}
\alias{az_vm_template}
\title{Virtual machine template class}
\format{
An R6 object of class \code{az_vm_template}, inheriting from \code{AzureRMR::az_template}.
}
\description{
Class representing a virtual machine deployment template. This class keeps track of all resources that are created as part of deploying a VM, and exposes methods for managing them.
}
\details{
A single virtual machine in Azure is actually a collection of resources, including any and all of the following.
\itemize{
\item Network interface (Azure resource type \code{Microsoft.Network/networkInterfaces})
\item Network security group (Azure resource type \code{Microsoft.Network/networkSecurityGroups})
\item Virtual network (Azure resource type \code{Microsoft.Network/virtualNetworks})
\item Public IP address (Azure resource type \code{Microsoft.Network/publicIPAddresses})
\item The VM itself (Azure resource type \code{Microsoft.Compute/virtualMachines})
}

By wrapping the deployment template used to create these resources, the \code{az_vm_template} class allows managing them all as a single entity.
}
\section{Fields}{

The following fields are exposed, in addition to those provided by the \link[AzureRMR:az_template]{AzureRMR::az_template} class.
\itemize{
\item \code{dns_name}: The DNS name for the VM. Will be NULL if the VM is not publicly visible, or doesn't have a domain name assigned to its public IP address.
\item \code{identity}: The managed identity details for the VM. Will be NULL if the VM doesn't have an identity assigned.
}
}

\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_template]{AzureRMR::az_template} class.
\itemize{
\item \code{start(wait=TRUE)}: Start the VM. By default, wait until the startup process is complete.
\item \code{stop(deallocate=TRUE, wait=FALSE)}: Stop the VM. By default, deallocate it as well.
\item \code{restart(wait=TRUE)}: Restart the VM.
\item \code{run_deployed_command(command, parameters, script)}: Run a PowerShell command on the VM.
\item \code{run_script(script, parameters)}: Run a script on the VM. For a Linux VM, this will be a shell script; for a Windows VM, a PowerShell script. Pass the script as a character vector.
\item \code{sync_vm_status()}: Check the status of the VM.
\item \code{resize(size, deallocate=FALSE, wait=FALSE)}: Resize the VM. Optionally stop and deallocate it first (may sometimes be necessary).
\item \code{redeploy()}: Redeploy the VM.
\item \code{reimage()}: Reimage the VM.
\item \code{get_public_ip_address(nic=1, config=1)}: Get the public IP address of the VM. Returns NA if the VM is stopped, or is not publicly accessible.
\item \code{get_private_ip_address(nic=1, config=1)}: Get the private IP address of the VM.
\item \code{get_public_ip_resource(nic=1, config=1)}: Get the Azure resource for the VM's public IP address.
\item \code{get_nic(nic=1)}: Get the VM's network interface resource.
\item \code{get_vnet(nic=1, config=1)}: Get the VM's virtual network resource.
\item \code{get_nsg(nic=1, config=1)}: Get the VM's network security group resource. Note that an NSG can be attached to either the VM's network interface or to its virtual network subnet; if there is an NSG attached to both, this method returns a list containing the two NSG resource objects.
\item \code{get_disk(disk="os")}: Get a managed disk resource attached to the VM. The \code{disk} argument can be "os" for the OS disk, or a number indicating the LUN of a data disk. AzureVM only supports managed disks.
\item \code{add_extension(publisher, type, version, settings=list(), protected_settings=list(), key_vault_settings=list())}: Add an extension to the VM.
\item \code{do_vm_operation(...)}: Carries out an arbitrary operation on the VM resource. See the \code{do_operation} method of the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class for more details.
}

Many of these methods are actually provided by the \link{az_vm_resource} class, and propagated to the template as active bindings.
}

\examples{
\dontrun{

sub <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")

vm <- sub$get_vm("myvm")

vm$identity

vm$start()
vm$get_private_ip_address()
vm$get_public_ip_address()

vm$run_script("echo hello world! > /tmp/hello.txt")

vm$stop()
vm$get_private_ip_address()
vm$get_public_ip_address()  # NA, assuming VM has a dynamic IP address

vm$resize("Standard_DS13_v2")
vm$sync_vm_status()

}
}
\seealso{
\link[AzureRMR:az_template]{AzureRMR::az_template}, \link{create_vm}, \link{get_vm}, \link{delete_vm}

\href{https://docs.microsoft.com/en-us/rest/api/compute/virtualmachines}{VM API reference}
}
