% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lb_config.R
\name{lb_config}
\alias{lb_config}
\alias{lb_probe}
\alias{lb_rule}
\title{Load balancer configuration}
\usage{
lb_config(type = NULL, rules = list(), probes = list(), ...)

lb_probe(name, port, interval = 5, fail_on = 2, protocol = "Tcp")

lb_rule(name, frontend_port, backend_port = frontend_port,
  protocol = "Tcp", timeout = 5, floating_ip = FALSE, probe_name)
}
\arguments{
\item{type}{The SKU of the load balancer resource: "basic" or "standard". If NULL (the default), this will be determined based on the VM scaleset's configuration. Note that the load balancer SKU must be the same as that of its public IP address.}

\item{rules}{A list of load balancer rules, each obtained via a call to \code{lb_rule}.}

\item{probes}{A list of health checking probes, each obtained via a call to \code{lb_probe}. There must be a probe corresponding to each rule.}

\item{...}{Other named arguments that will be treated as resource properties.}

\item{name}{For \code{lb_rule}, a name for the load balancing rule.}

\item{port}{For \code{lb_probe}, the port to probe.}

\item{interval}{For \code{lb_probe}, the time interval between probes in seconds.}

\item{fail_on}{For \code{lb_probe}, the probe health check will fail after this many non-responses.}

\item{protocol}{For \code{lb_probe} and \code{lb_rule}, the protocol: either "Tcp" or "Ip".}

\item{frontend_port, backend_port}{For \code{lb_rule}, the ports for this rule.}

\item{timeout}{The timeout interval for the rule. The default is 5 minutes.}

\item{floating_ip}{Whether to use floating IP addresses (direct server return). Only needed for specific scenarios, and when the frontend and backend ports don't match.}

\item{probe_name}{The name of the corresponding health check probe.}
}
\description{
Load balancer configuration
}
\examples{
lb_config()
lb_config(type="basic")
lb_config(
    rules=list(lb_rule_ssh, lb_rule_rdp),
    probes=list(lb_probe_ssh, lb_probe_rdp)
)
}
\seealso{
\link{create_vm_scaleset}, \link{vmss_config}, \link{lb_rules} for some predefined load balancing rules and probes
}
