% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_records.R
\name{get_range_crude}
\alias{get_range_crude}
\title{Download records from a specified range from the Bath: Hacked datastore}
\usage{
get_range_crude(from = NULL, to = NULL, abbrs = NULL)
}
\arguments{
\item{from}{Datetime object (or "YYYY-MM-DD HH:MM:SS" string) for the earliest record to retrieve.}

\item{to}{Datetime object (or "YYYY-MM-DD HH:MM:SS" string) for the latest record to retrieve.}

\item{abbrs}{Abbreviations of names of car parks from which to retrieve
records:
\describe{
  \item{as}{Avon Street CP}
  \item{cs}{Charlotte Street CP}
  \item{l}{Lansdown P+R}
  \item{n}{Newbridge P+R}
  \item{od}{Odd Down P+R}
  \item{p}{Podium CP}
  \item{sg}{SouthGate General CP}
  \item{sr}{Southgate Rail CP}
  \item{t}{test car park}
}}
}
\value{
Car parking records from the specified date range.
}
\description{
Retrieve raw records uploaded to the datastore within a specified date range and/or from a subset of car parks.
}
\examples{
# Records for 1st June 2016
raw_data <- get_range_crude("2016-06-01 00:00:00", "2016-06-01 23:59:59")
\donttest{
# All records from Podium CP since 14:30 on 1st January 2017
raw_data <- get_range_crude(from = "2017-01-01 14:30:00", abbrs = "p")

# All records from P+Rs before 2015
raw_data <- get_range_crude(to = "2014-12-31 23:59:59", abbrs = c("l", "n", "od"))
}
}
\seealso{
\code{\link{get_all_crude}}
}
