% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.contribution}
\alias{kernel.contribution}
\title{Contribution of each observation to the kernel density hypervolume.}
\usage{
kernel.contribution(comm, func = "neighbor", relative = FALSE)
}
\arguments{
\item{comm}{A 'Hypervolume' or 'HypervolumesList' object, preferably built using function kernel.build.}

\item{func}{Calculate contribution using either closest "neighbor" or leave "one out" approach.}

\item{relative}{A boolean (T/F) indicating whether contribution should be relative to total FD (proportional contribution per individual or species). If FALSE, the sum of contributions for each site is equal to total FD, if TRUE it is 1.}
}
\value{
A matrix with the contribution values of each species or individual for each site.
}
\description{
Contribution of each species or individual to the total volume of one or more kernel hypervolumes.
}
\details{
Contribution is a measure of functional rarity (sensu Violle et al., 2017; Carmona et al., 2017) that allows to map the contribution of each observation to the richness components of FD (Mammola & Cardoso, 2020).
If using func = "neighbor", each random point will be attributed to the closest species. The contribution of each species will be proportional to the number of its points. The sum of contributions of all species is equal to total richness.
Note that the contribution of a species or individual can be negative if leave-one-out approach is taken, if the removal of an observation increases the total volume (see Figure 2d in Mammola & Cardoso 2020).  
This might happen, although not always, in cases when the presence of a given species decreases the average distance between all the species in the community, i.e., when a given species is close to the "average" species of that community, making that community less diverse in some sense (Mammola & Cardoso, 2020).
}
\examples{
\dontrun{
comm = rbind(c(1,3,0,5,3), c(3,2,5,1,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

hv = kernel.build(comm[1,], trait)
kernel.contribution(hv)
hvlist = kernel.build(comm, trait, axes = 2)
kernel.contribution(hvlist)
kernel.contribution(hvlist, relative = TRUE)
}
}
\references{
Carmona, C.P., de Bello, F., Sasaki, T., Uchida, K. & Partel, M. (2017) Towards a common toolbox for rarity: A response to Violle et al. Trends in Ecology and Evolution, 32(12): 889-891.

Mammola, S. & Cardoso, P. (2020) Functional diversity metrics using kernel density n-dimensional hypervolumes. Methods in Ecology and Evolution, 11: 986-995.

Violle, C., Thuiller, W., Mouquet, N., Munoz, F., Kraft, N.J.B., Cadotte, M.W., ... & Mouillot, D. (2017) Functional rarity: The ecology of outliers. Trends in Ecology and Evolution, 32: 356-367.
}
