% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_viz_shots_gradient.R
\name{do_viz_shots_gradient}
\alias{do_viz_shots_gradient}
\title{Visualization of the shots statistics with advanced features}
\usage{
do_viz_shots_gradient(data_filter, type, metric, data_shots_zones, language = "English")
}
\arguments{
\item{data_filter}{Shooting filtered data obtained with \code{\link{do_filter_data}}.}

\item{type}{Options are 'team' for team statistics, 'player' for player statistics and 
'all' for the whole league.}

\item{metric}{Options are 'fg' for the field goal percentage, 'pps' for the points per shot
and 'none' if plotting a heatmap is preferred.}

\item{data_shots_zones}{Shooting data with the court zones.}

\item{language}{Language of the titles. Valid options are 'English' and 'Spanish' so far.}
}
\value{
A plot.
}
\description{
Create a visualization of the left half of the court and compare either the field goal
percentage or the points per shot of a given player with respect to the league. 
In addition, it can also show a heatmap with the zones where the player takes the shots.
}
\examples{
\dontrun{
df0 <- do_divide_court_zones(acb_shooting_data_2425)

df1 <- do_filter_data(df0, "2024-2025", "", "", "", "", "")

do_viz_shots_gradient(df1, "all", "none", df0)

df1 <- do_filter_data(df0, "2024-2025", "", "", "", "", "D. Ennis")

do_viz_shots_gradient(df1, "player", "none", df0)
do_viz_shots_gradient(df1, "player", "fg", df0)

df1 <- do_filter_data(df0, "2024-2025", "Valencia Basket", "", "", "", "")

do_viz_shots_gradient(df1, "team", "none", df0)
}

}
\seealso{
\code{\link{do_divide_court_zones}}, \code{\link{do_filter_data}}, 
\code{\link{do_shots_stats}}, \code{\link{do_prepare_data_gradient}}
}
\author{
Guillermo Vinue
}
