% Generated by roxygen2 (4.0.2): do not edit by hand
\name{itostr}
\alias{itostr}
\title{Convert Integers to Strings}
\usage{
itostr(x, base = 10L)
}
\arguments{
\item{x}{[\code{integer}]\cr
Vector of integers to convert.}

\item{base}{[\code{integer(1)}]\cr
Base for conversion. Values between 2 and 36 (inclusive) are allowed.}
}
\value{
\code{character(length(x))}.
}
\description{
This is the counterpart of \code{\link[base]{strtoi}}.
For a base greater than \sQuote{10}, letters \sQuote{a} to \sQuote{z}
are used to represent \sQuote{10} to \sQuote{35}.
}
\examples{
# binary representation of the first 10 natural numbers
itostr(1:10, 2)

# base36 encoding of a large number
itostr(1e7, 36)
}

