% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose_DAG.R
\name{propose_DAG}
\alias{propose_DAG}
\title{MCMC proposal distribution (internal function)}
\usage{
propose_DAG(DAG, fast)
}
\arguments{
\item{DAG}{Adjacency matrix of the current DAG}

\item{fast}{boolean, if \code{TRUE} an approximate proposal is implemented}
}
\value{
A list containing the \eqn{(q,q)} adjacency matrix of the proposed DAG, the type of applied operator (with values in \eqn{{1,2,3}}), the numerical labels of the nodes involved in the move, the integer number of direct successors of \code{DAG} and of the proposed DAG
}
\description{
This function implements a proposal distribution for the MCMC scheme of \code{learn_DAG}.
Given an input \code{DAG}, it first builds the set of all DAGs which can be obtained by applying a local move
(insertion, deletion or reversal of one edge) to \code{DAG},
that is the set of direct successors of \code{DAG};
next, it randomly draws one candidate (proposed) DAG from the so-obtained set.
Finally, the set of direct successors of the proposed DAG is constructed.
The function returns: the proposed DAG, the type of operator applied to \code{DAG} to obtain the proposed DAG
(with value 1 if insertion, 2 if deletion, 3 if reversal),
the nodes involved in the local move, the number of direct successors of \code{DAG} and of the proposed DAG.
If \code{fast = TRUE} the two numbers of direct successors are approximated by the number of possible operators that can be applied to the DAGs
(equal for the two graphs)
}
