% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kBCT}
\alias{kBCT}
\title{k-Bayesian Context Trees (kBCT) algorithm}
\usage{
kBCT(input_data, depth, k, beta = NULL)
}
\arguments{
\item{input_data}{the sequence to be analysed. 
The sequence needs to be a "character" object. See the examples section on how to transform any dataset to a "character" object.}

\item{depth}{maximum memory length.}

\item{k}{number of the a posteriori most likely tree models to be identified.}

\item{beta}{hyper-parameter of the model prior. 
Takes values between 0 and 1. If not initialised in the call function, the default value is \ifelse{html}{\out{1-2<sup>-m+1</sup>}}{\eqn{1 - 2^{-m+1}}}, 
where \ifelse{html}{\out{m}}{\eqn{m}} is the size of the alphabet; for more information see: \href{https://arxiv.org/pdf/2007.14900.pdf}{Kontoyiannis et al. (2020)}.}
}
\value{
a list object which includes:
\item{Contexts}{top k a posteriori most likely models. Each model given as a list object containing the contexts of its leaves.}
\item{Results}{a dataframe with the following columns: prior probability, log(prior probability), posterior probability, log(posterior probability), posterior odds, number of leaves, maximum depth, BIC score, AIC score and maximum log-likelihood. }
}
\description{
Finds the top k a posteriori most likely tree models.
}
\examples{
# Finding the first 5 a posteriori most likely models with maximum depth <= 5 
# for the SP500 dataset (with default value beta):

kBCT(SP500, 5, 2)  

# For custom beta (e.g. 0.8):

kBCT(SP500, 5, 2, 0.8)  

# The type of the input dataset is "character"
# If the dataset is contained within a vector:

q <- c(1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0)

# Convert a vector to a "character" object:
s <- paste(q, collapse = "")

kBCT(s, 2, 2)

# Reading a file using the readChar function 

# Example 1: The dataset is stored in a .txt file

# fileName <- '~/example_data.txt' # fileName stores the path to the dataset

# s<-readChar(fileName, file.info(fileName)$size)

# Make sure that s does not contain any "\n" at the end of the string
# To remove last entry:
# s<-gsub('.$', '', s)

# To remove any unwanted characters (e.g. "\n"):
# s<-gsub('\n', '', s)

# Example 2: The dataset is stored in a .csv file

# fileName <- '~/example_data.csv' # fileName stores the path to the dataset

# s<-readChar(fileName, file.info(fileName)$size)

# Depending on the running environment, 
# s might contain unwanted characters such as: "\n" or "\r\n".
# Remove any unwanted characters (e.g. "\r\n"):
# s<-gsub('\r\n', '', s)

# Always make sure that s does not contain any unwanted characters

}
\seealso{
\code{\link{BCT}}
}
