% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkBeIds.R
\name{checkBeIds}
\alias{checkBeIds}
\title{Check biological entities (BE) identifiers}
\usage{
checkBeIds(ids, be, source, organism, stopThr = 1, caseSensitive = FALSE)
}
\arguments{
\item{ids}{a vector of identifiers to be checked}

\item{be}{biological entity. See \link{getBeIds}. \strong{Guessed if not provided}}

\item{source}{source of the ids. See \link{getBeIds}. \strong{Guessed if not provided}}

\item{organism}{the organism of interest. See \link{getBeIds}.
\strong{Guessed if not provided}}

\item{stopThr}{proportion of non-recognized IDs above which an error is
thrown. Default: 1 ==> no check}

\item{caseSensitive}{if FALSE (default) the case is not taken into account
when checking ids.}
}
\value{
invisible(TRUE). Stop if too many (see stopThr parameter) ids are not
found. Warning if any id is not found.
}
\description{
This function takes a vector of identifiers and verify if they can
be found in the provided source database according to the BE type and
the organism of interest. If an ID is in the DB but not linked directly nor
indirectly to any entity then it is considered as not found.
}
\examples{
\dontrun{
checkBeIds(
   ids=c("10", "100"), be="Gene", source="EntrezGene", organism="human"
)
checkBeIds(
   ids=c("10", "100"), be="Gene", source="Ens_gene", organism="human"
)
}

}
\seealso{
\link{getBeIds}, \link{listBeIdSources}, \link{getAllBeIdSources}
}
