% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETS.predict.R
\name{BETS.predict}
\alias{BETS.predict}
\title{Get the predicted values of a model and visualize it}
\usage{
BETS.predict(..., actual = NULL, main = "", ylab = "", xlim = NULL,
  style = "dygraphs", unnorm = NULL, knit = F)
}
\arguments{
\item{...}{arguments passed on to \link[forecast]{forecast}. If the model is a neural network, these arguments will be passed on to \link[BETS]{BETS.grnn.test}.}

\item{actual}{A \code{numeric vector}. The actual values (to be compared with predicted values).}

\item{main}{A \code{character}. The name of the prediction plot.}

\item{ylab}{A \code{character}. The Y axis label.}

\item{xlim}{A \code{numeric vector}. The limits of the X axis.}

\item{style}{A \code{character}. Can be either 'dygraphs' (the \link[dygraphs]{dygraph} function will be use to make the plot, which is going to be HTML based) or 'normal' (standard R functions will be used to make the plot)}

\item{unnorm}{A \code{numeric vector}. If predictions must be unnormalized, set the first element of this vector to the mean and the second, to the standard deviation.}

\item{knit}{A \code{boolean}. Set this parameter to \code{TRUE} if}
}
\value{
Besides the prediction plot, this function returns an object whose fields are:

\itemize{
\item{\code{accuracy}: An object returned by \link[forecast]{accuracy}. It is a table containing several accuracy measures}
\item{\code{predictions}: A \code{numeric vector} containing the predicted values. }
}
}
\description{
This function is built upon \link[forecast]{forecast}. Besides the model predictions, it returns an accuracy measure table (calculated by the \link[forecast]{accuracy} function) and a graph showing the original series, the predicted values and the actual values.
}
\author{
Talitha Speranza \email{talitha.speranza@fgv.br}
}

