% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.explore.R
\name{plot.select.explore}
\alias{plot.select.explore}
\title{Plot \code{select.explore} Network}
\usage{
\method{plot}{select.explore}(
  x,
  layout = "circle",
  edge_colors = "classic",
  node_labels = NULL,
  node_labels_color = "black",
  node_groups = NULL,
  node_outer_size = 12,
  node_inner_size = 11,
  alpha = 0.5,
  txt_size = 8,
  edge_multiplier = 1,
  ...
)
}
\arguments{
\item{x}{object of class \code{select.explore}}

\item{layout}{network layout (\link[sna]{gplot.layout})}

\item{edge_colors}{color theme for positive and negative edges}

\item{node_labels}{node labels}

\item{node_labels_color}{node labels color}

\item{node_groups}{node group indicator}

\item{node_outer_size}{node border size}

\item{node_inner_size}{node size}

\item{alpha}{edge transparency}

\item{txt_size}{node text size}

\item{edge_multiplier}{constant to change edge width (egde * edge_multiplier)}

\item{...}{additional arguments (\link[GGally]{ggnet2})}
}
\value{
object of class \code{ggplot}
}
\description{
Plot \code{select.explore} Network
}
\examples{
\donttest{
Y <- BGGM::bfi[1:500, 1:20]

# fit model
fit_explore <- explore(Y)

# select the graph (edge set E)

E <- select(fit_explore)


# plot
plt <- plot(E,
            node_labels = letters[1:20],
            node_labels_color = "white",
            node_groups = rep(c("1", "2", "3", "4"), each = 5),
            edge_colors = "classic", txt_size = 8,
            alpha = 0.5, palette = "Set2")
}
}
