% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{rmse.bgvar.predict}
\alias{rmse.bgvar.predict}
\alias{rmse}
\title{Compute root mean squared errors}
\usage{
rmse(object, ...)
}
\arguments{
\item{object}{an object of class \code{bgvar.predict}.}

\item{...}{additional arguments.}
}
\value{
Returns an object of class \code{bgvar.rmse}, which is a matrix of dimension h times K, whereas h is the forecasting horizon and K is the number of variables in the system.
}
\description{
Computes and prints root mean squared errors (RMSEs) of an object of class \code{bgvar.predict}.
}
\examples{
\dontshow{
library(BGVAR)
data(eerData)
cN<-c("EA","US","UK")
eerData<-eerData[cN]
W.trade0012<-apply(W.trade0012[cN,cN],2,function(x)x/rowSums(W.trade0012[cN,cN]))
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,draws=100,burnin=100,plag=1,prior="SSVS",
                      eigen=TRUE,h=8)
fcast <- predict(model.ssvs.eer,n.ahead=8,save.store=TRUE)
rmse <- rmse(fcast)
}
\donttest{
library(BGVAR)
data(eerData)
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,draws=100,burnin=100,plag=1,prior="SSVS",
                      eigen=TRUE,h=8)
fcast <- predict(model.ssvs.eer,n.ahead=8,save.store=TRUE)
rmse   <- rmse(fcast)
}
}
\author{
Maximilian Boeck, Martin Feldkircher
}
