% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fevd.R
\name{gfevd}
\alias{gfevd}
\alias{gfevd.bgvar}
\title{Generalized Forecast Error Variance Decomposition}
\usage{
gfevd(x, n.ahead=24, running=TRUE, applyfun=NULL, cores=NULL, verbose=TRUE)
}
\arguments{
\item{x}{an object of class \code{bgvar}.}

\item{n.ahead}{the forecast horizon.}

\item{running}{Default is set to \code{TRUE} and implies that only a running mean over the posterior draws is calculated. A full analysis including posterior bounds is likely to cause memory issues.}

\item{applyfun}{Allows for user-specific apply function, which has to have the same interface than \code{lapply}. If \code{cores=NULL} then \code{lapply} is used, if set to a numeric either \code{parallel::parLapply()} is used on Windows platforms and \code{parallel::mclapply()} on non-Windows platforms.}

\item{cores}{Specifies the number of cores which should be used. Default is set to \code{NULL} and \code{applyfun} is used.}

\item{verbose}{If set to \code{FALSE} it suppresses printing messages to the console.}
}
\value{
Returns a list with two elements \itemize{
\item{\code{GFEVD}}{ a three or four-dimensional array, with the first dimension referring to the K time series that are decomposed into contributions of K time series (second dimension) for \code{n.ahead} forecast horizons. In case \code{running=TRUE} only the posterior mean else also its 16\% and 84\% credible intervals is contained in the fourth dimension.}
\item{\code{xglobal}}{ used data of the model.}
}
}
\description{
This function calculates a complete generalized forecast error variance decomposition (GFEVDs) based on generalized impulse response functions akin to Lanne-Nyberg (2016). The Lanne-Nyberg (2016) corrected GFEVD sum up to unity.
}
\examples{
\dontshow{
library(BGVAR)
data(eerDatasmall)
model.ssvs.eer<-bgvar(Data=eerDatasmall,W=W.trade0012.small,draws=100,burnin=100,plag=1,
                      prior="SSVS",thin=1,eigen=TRUE)
                      
GFEVD<-gfevd(model.ssvs.eer,n.ahead=24,running=TRUE)
}
}
\references{
Lanne, M. and H. Nyberg (2016) \emph{Generalized Forecast Error Variance Decomposition for Linear and Nonlinear Multivariate Models.} Oxford Bulletin of Economics and Statistics, Vol. 78(4), pp. 595-603.
}
\seealso{
\code{\link{bgvar}}.
}
\author{
Maximilian Boeck, Martin Feldkircher
}
