% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMarginals.R
\name{constructFormula}
\alias{constructFormula}
\title{Construct a model formula from parameter constraint matrix}
\usage{
constructFormula(consMatrix = NULL, consVector = NULL,
  naming = c("h1", "h2", "b", "m1", "m2", "e1", "e2"),
  extraVars = c("d1", "d2"), formulaArgs = c("effect", "fn"))
}
\arguments{
\item{consMatrix}{Constraint matrix}

\item{consVector}{Constraint vector}

\item{naming}{Parameter names}

\item{extraVars}{Non-parameter variables used in the formula and function
evaluation. These will be appended to the formula.}

\item{formulaArgs}{Character vector of length two. First element indicates
name for the response variable. Second element indicates name of the
function.}
}
\value{
This function returns a model construct appropriate for
  \code{\link{fitMarginals}} function. It also separates variables into those
  that are free and those which are constrained.
}
\description{
For parameter names defined in \code{naming} vector, formula is constructed
so that \code{consMatrix \%*\% naming = consVector} is satisfied. Constraint
coefficients are normalized and convert into fractions.
}
\examples{
  constM <- rbind(c(0, 0, 1, 0, 0, 0, 0),
                  c(0, 0, 0, -1, 1, 0, 0))
  constV <- c(0.9, 0)
  constructFormula(constM, constV)
}
