% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMisc.R
\name{ids2rownum}
\alias{ids2rownum}
\title{Convert Vector of ids into Vector of Row Numbers}
\usage{
ids2rownum(ids, data, idname)
}
\arguments{
\item{ids}{vector of ids}

\item{data}{data frame}

\item{idname}{unique id}
}
\value{
vector of row numbers
}
\description{
ids2rownum takes a vector of ids and converts it to the right
 row number in the dataset; ids should be unique in the dataset
 that is, don't pass the function panel data with multiple same ids
}
\examples{
ids <- seq(1, 1000, length.out = 100)
ids <- ids[order(runif(100))]
df <- data.frame(id = ids)
ids2rownum(df$id, df, "id")

}
