% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MIXcluster.R
\name{plot.MIXcluster}
\alias{plot.MIXcluster}
\title{Plotting clustering results for "\code{MIXcluster}" objects}
\usage{
\method{plot}{MIXcluster}(
  x,
  type = c("heatmap", "chain")[1],
  chain.obj = c("n.cluster", "a", "b", "Lambda", "Omega", "all")[1],
  ...
)
}
\arguments{
\item{x}{an object of class "\code{MIXcluster}"}

\item{type}{what type of plot should be drawn. Possible types are:
\describe{
    \item{\code{"heatmap"}}{ (default) draws a heatmap of the average similarity matrix for the effective iterations of the MCMC.}
    \item{\code{"chain"}}{ for the evolution and histograms of the chains for parameters in the model.  }
    }}

\item{chain.obj}{if \code{type="chain"}, this specifies what chain will be plotted. Possible types are:
\describe{
    \item{\code{"n.cluster"}}{ (default) for the number of clusters.}
    \item{\code{"a"}}{ for the \eqn{a} parameter of the model.}
    \item{\code{"b"}}{ for the \eqn{b} parameter of the model.}
    \item{\code{"Lambda"}}{ one plot for each element in the diagonal of the \eqn{\Lambda} matrix of the model (variance of latent variables).}
    \item{\code{"Omega"}}{ one plot for each element above the diagonal of the \eqn{\Omega} matrix of the model (correlation between latent variables).}
    \item{\code{"all"}}{ for all of the above.}
    }}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Plotting method for objects inheriting from class "\code{MIXcluster}".
}
\seealso{
\code{\link{MIXclustering}}
}
