clusterplots <-
function(L,data){
    
    # Function that plots the time series clusters generated by either of
    # the functions: "tseriesca", "tseriescm" or "tseriescq". 
    #
    # IN:
    # 
    # L       <- output list from the functions: "tseriesca", "tseriescm"
    #            or "tseriescq".
    # data    <- Data frame with the time series information.
    # 
    # OUT:
    # 
    # Plots of the time series clusters. 
    
    data <- scaleandperiods(data)  
    mydata <- data$mydata              # Matrix with the scaled data.
    periods <- data$periods            # Array with the data periods.
    
    T <- nrow(mydata)
    fT <- floor(T/3)
    auxtt <- matrix(0,fT,1)
    
    for(i in 1:fT){
      auxtt[i] <- 3*i
    }
    
    mstar <- L$mstar
    gnstar <- L$gnstar
    
    par(mfrow = c(2,2))
    
    for(j in 1:mstar){
      cc <- as.matrix(which(gnstar == j))
      cl <- rainbow(nrow(cc))
      
      plot((1:T),mydata[,cc[1,1]],type = "l",main = paste("Group",j),xlab = "",xaxt = 'n',ylab = "Scaled variable in [0,1]",col = cl[1])
      axis(1,at = auxtt,labels = periods[auxtt],las = 2,tck = 0)
      
      if(nrow(cc) > 1){
        for(i in 2:nrow(cc)){
          lines((1:T),mydata[,cc[i,1]],col = cl[i],lty=((i%%6)+1))
        } 
      }
      
    }
    
  }
