% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbd.R
\name{pnbd.ConditionalExpectedTransactions}
\alias{pnbd.ConditionalExpectedTransactions}
\title{Pareto/NBD Conditional Expected Transactions}
\usage{
pnbd.ConditionalExpectedTransactions(params, T.star, x, t.x, T.cal, hardie)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in
that order. r and alpha are unobserved parameters for the NBD transaction
process. s and beta are unobserved parameters for the Pareto (exponential
gamma) dropout process.}

\item{T.star}{length of time for which we are calculating the expected number
of transactions.}

\item{x}{number of repeat transactions in the calibration period T.cal, or a
vector of calibration period frequencies.}

\item{t.x}{time of most recent repeat transaction, or a vector of recencies.}

\item{T.cal}{length of calibration period, or a vector of calibration period
lengths.}

\item{hardie}{if TRUE, have \code{\link{pnbd.PAlive}} use \code{\link{h2f1}}
instead of \code{\link[hypergeo]{hypergeo}}.}
}
\value{
Number of transactions a customer is expected to make in a time
period of length t, conditional on their past behavior. If any of the input
parameters has a length greater than 1, this will be a vector of expected
number of transactions.
}
\description{
Uses Pareto/NBD model parameters and a customer's past transaction behavior
to return the number of transactions they are expected to make in a given
time period.
}
\details{
E[X(T.cal, T.cal + T.star) | x, t.x, r, alpha, s, beta]

\code{T.star}, \code{x}, \code{t.x}, and \code{T.cal} may be vectors. The
standard rules for vector operations apply - if they are not of the same
length, shorter vectors will be recycled (start over at the first element)
until they are as long as the longest vector. It is advisable to keep vectors
to the same length and to use single values for parameters that are to be the
same for all calculations. If one of these parameters has a length greater
than one, the output will be a vector of probabilities.
}
\examples{
params <- c(0.55, 10.56, 0.61, 11.64)
# Number of transactions a customer is expected to make in 2 time
# intervals, given that they made 10 repeat transactions in a time period
# of 39 intervals, with the 10th repeat transaction occurring in the 35th
# interval.
pnbd.ConditionalExpectedTransactions(params, 
                                     T.star = 2, 
                                     x = 10, 
                                     t.x = 35, 
                                     T.cal = 39, 
                                     hardie = TRUE)

# We can also compare expected transactions across different
# calibration period behaviors:
pnbd.ConditionalExpectedTransactions(params, 
                                     T.star = 2, 
                                     x = 5:20, 
                                     t.x = 25, 
                                     T.cal = 39, 
                                     hardie = TRUE)
}
\references{
Fader, Peter S., and Bruce G.S. Hardie. "A Note on Deriving the
Pareto/NBD Model and Related Expressions." November. 2005. Web.
\url{http://www.brucehardie.com/notes/008/}
}
\seealso{
\code{\link{pnbd.Expectation}}
}
