% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbd.R
\name{pnbd.PlotRateHeterogeneity}
\alias{pnbd.PlotRateHeterogeneity}
\title{Plot Pareto/NBD Rate Heterogeneity}
\usage{
pnbd.PlotRateHeterogeneity(params, func, lim = NULL)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in
that order. r and alpha are unobserved parameters for the NBD transaction
process. s and beta are unobserved parameters for the Pareto (exponential
gamma) dropout process.}

\item{func}{A string that is either "pnbd.PlotDropoutRateHeterogeneity" or
"pnbd.PlotTransactionRateHeterogeneity".}

\item{lim}{The upper-bound of the x-axis. A number is chosen by the function
if none is provided.}
}
\value{
Depending on the value of \code{func}, either the distribution of
customers' propensities to purchase or the distribution of customers'
propensities to drop out.
}
\description{
A helper for plotting either the estimated gamma distribution of mu
(customers' propensities to drop out), or the estimated gamma distribution of
lambda (customers' propensities to purchase).
}
\seealso{
\code{\link{pnbd.PlotDropoutRateHeterogeneity}}

\code{\link{pnbd.PlotTransactionRateHeterogeneity}}
}
