% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bgnbd.LL}
\alias{bgnbd.LL}
\alias{bgnbd.cbs.LL}
\title{BG/NBD Log-Likelihood}
\usage{
bgnbd.cbs.LL(params, cal.cbs)

bgnbd.LL(params, x, t.x, T.cal)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that order. r and alpha are unobserved parameters for the NBD transaction process. a and b are unobserved parameters for the Beta geometric dropout process.}

\item{cal.cbs}{calibration period CBS (customer by sufficient statistic). It must contain columns for frequency ("x"), recency ("t.x"), and total time observed ("T.cal"). Note that recency must be the time between the start of the calibration period and the customer's last transaction, not the time between the customer's last transaction and the end of the calibration period. If your data is compressed (see
\code{\link{bgnbd.compress.cbs}}), a fourth column labelled "custs"
(number of customers with a specific combination of recency,
frequency and length of calibration period) is available.}

\item{x}{number of repeat transactions in the calibration period
T.cal, or a vector of transaction frequencies.}

\item{t.x}{time of most recent repeat transaction, or a vector of
recencies.}

\item{T.cal}{length of calibration period, or a vector of
calibration period lengths.}
}
\value{
For \code{bgnbd.cbs.LL}, the total log-likelihood of the
provided data. For \code{bgnbd.LL}, a vector of log-likelihoods as
long as the longest input vector (\code{x}, \code{t.x}, or \code{T.cal}).
}
\description{
Calculates the log-likelihood of the BG/NBD model.
}
\details{
\code{x}, \code{t.x}, \code{T.cal} may be vectors. The standard
rules for vector operations apply - if they are not of the same
length, shorter vectors will be recycled (start over at the first
element) until they are as long as the longest vector. It is
advisable to keep vectors to the same length and to use single
values for parameters that are to be the same for all
calculations. If one of these parameters has a length greater than
one, the output will be also be a vector.
}
\examples{
data(cdnowSummary)

cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

# random assignment of parameters
params <- c(0.5, 6, 1.2, 3.3)
# returns the log-likelihood of the given parameters
bgnbd.cbs.LL (params, cal.cbs)

# compare the speed and results to the following:
cal.cbs.compressed <- bgnbd.compress.cbs(cal.cbs)
bgnbd.cbs.LL (params, cal.cbs.compressed)

# Returns the log likelihood of the parameters for a customer who
# made 3 transactions in a calibration period that ended at t=6,
# with the last transaction occurring at t=4.
bgnbd.LL(params, x=3, t.x=4, T.cal=6)

# We can also give vectors as function parameters:
set.seed(7)
x <- sample(1:4, 10, replace = TRUE)
t.x <- sample(1:4, 10, replace = TRUE)
T.cal <- rep(4, 10)
bgnbd.LL(params, x, t.x, T.cal)
}
\seealso{
\code{\link{bgnbd.EstimateParameters}}
}

