% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_params.R
\name{get_data_params}
\alias{get_data_params}
\title{Get parameters for building a model with known relationships}
\usage{
get_data_params(args)
}
\arguments{
\item{args}{A character vector of arguments (character strings) of the form "<name>=<value>". 
Values will be converted to logical or numeric when necessary.
Accepted <names> are below. Defaults in parenthesis:
\describe{
\item{decomp}{Either 'CP' or 'Tucker'. (Tucker)}
\item{row.share}{Logical. Should the variance be shared across rows of the projection matrices? 
This will cause predictors to be or excluded for the whole model, instead of just for particular 
latent factors. (T)}
\item{seed}{Numeric. Seed used for random initialization. (NA)}
\item{scale}{Logical. Should the input data columns should be scaled to have mean 0 and 
standard deviation 1. (TRUE)}
\item{m1.rows}{Numeric. Number of rows (samples) for mode 1. (20)}
\item{m2.rows}{Numeric. Number of rows (samples) for mode 2. (25)}
\item{m3.rows}{Numeric. Number of rows (samples) for mode 3. (10)}
\item{m1.cols}{Numeric. Number of columns (predictors) for mode 1. (100)}
\item{m2.cols}{Numeric. Number of columns (predictors) for mode 2. (150)}
\item{m3.cols}{Numeric. Number of columns (predictors) for mode 3. (0)}
\item{R}{Numeric. If \code{decomp=='CP'} the dimension of the latent space for all modes. (4)}
\item{R1}{Numeric. If \code{decomp=='Tucker'} the dimension of the core (latent space) for
mode 1. (3)}
\item{R2}{Numeric. If \code{decomp=='Tucker'} the dimension of the core (latent space) for
mode 2. (3)}
\item{R3}{Numeric. If \code{decomp=='Tucker'} the dimension of the core (latent space) for
mode 3. (3)}
\item{A1.intercept}{Logical. Should a column of 1s be added to the input data for mode 1. (TRUE)}
\item{A2.intercept}{Logical. Should a column of 1s be added to the input data for mode 2. (TRUE)}
\item{A3.intercept}{Logical. Should a column of 1s be added to the input data for mode 3. (TRUE)}
\item{H1.intercept}{Logical. Should a column of 1s be added to the latent (H) matrix for mode 1. (TRUE)}
\item{H2.intercept}{Logical. Should a column of 1s be added to the latent (H) matrix for mode 2. (TRUE)}
\item{H3.intercept}{Logical. Should a column of 1s be added to the latent (H) matrix for mode 3. (TRUE)}
\item{m1.true}{Numeric. Number of predictors for mode 1 (not counting the constant) 
contributing to the response. (15)}
\item{m2.true}{Numeric. Number of predictors for mode 2 (not counting the constant) 
contributing to the response. (20)}
\item{m3.true}{Numeric. Number of predictors for mode 3 (not counting the constant) 
contributing to the response. (0)}
\item{A1.const.prob}{Numeric. Probability (0-1) of the constant term for mode 1 contributing 
to the response for mode 1. (1)}
\item{A2.const.prob}{Numeric. Probability (0-1) of the constant term for mode 2 contributing 
to the response. (1)}
\item{A3.const.prob}{Numeric. Probability (0-1) of the constant term for mode 3 contributing 
to the response. (1)}
\item{A.samp.sd}{Numeric. Standard deviation for sampling values for the projection (A) matrices. (1)}
\item{H.samp.sd}{Numeric. Standard deviation for sampling values for the latent (H) matrices. (1)}
\item{R.samp.sd}{Numeric. Standard deviation for sampling values for the core tensor. (1)}
\item{true.0D}{Numeric. 0 or 1, should a global intercept (0 dimensional intercept) be added
to all responses? Only possible if \code{H1.intercept==H2.intercept==H3.intercept==TRUE}.
\code{core.spar} is used if equal to \code{NA}. (NA)}
\item{true.1D.m[1-3]}{Numeric. Number of interactions of 1 dimension in the core tensor (non-zero elements
on the edges of the core tensor if \code{H#.intercept==TRUE}). \code{core.spar} is used if 
equal to \code{NA}. (NA)}
\item{true.2D.m[1-3]m[1-3]}{Numeric. Number of interactions of 2 dimensions in the core tensor (non-zero elements
of the faces of the core tensor if \code{H#.intercept==TRUE}). \code{core.spar} is used if 
equal to \code{NA}. (NA)}
\item{true.3D}{Numeric. Number of interactions of 3 dimensions in the core tensor (non-zero elements
internal to the core tensor). \code{core.spar} is used if equal to \code{NA}. (NA)}
\item{core.spar}{Numeric. Fraction of core elements that are non-zero. (1)}
\item{noise.sd}{Numeric. Relative standard deviation of noise added to response tensor. (0.1)}
}}
}
\value{
list of parameters used by \code{mk_toy} function. Values in \code{args} that
are not accepted parameters will be excluded and a warning displayed.
}
\description{
Read in vector of arguments, check their types and add them to a list \code{params} for 
building a model of input and response data with known relationships. If a parameter 
isn't in the given list the default is used.
}
\examples{
args <- c('decomp=Tucker', 'row.share=F',
          'A1.intercept=T', 'A2.intercept=T', 'A3.intercept=F',
          'H1.intercept=T', 'H2.intercept=T', 'H3.intercept=T',
          'R1=4', 'R2=4', 'R3=2')
data.params <- get_data_params(args)
}
\seealso{
\code{\link{mk_toy}}
}

