% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_data.R
\docType{data}
\name{input_data}
\alias{input_data}
\title{Object storing input data for BaTFLED algorithm with 3-D response tensor.}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
input_data
}
\description{
Object storing input data for BaTFLED algorithm with 3-D response tensor.
}
\section{Slots}{

\describe{
\item{\code{mode1.X}}{matrix of predictors for mode 1}

\item{\code{mode2.X}}{matrix of predictors for mode 2}

\item{\code{mode3.X}}{matrix of predictors for mode 3}

\item{\code{resp}}{three dimensional array of responses with dimensions matching the number 
of rows in mode1.X, mode2.X and mode3.X}
}}
\examples{
a <- input_data$new(mode1.X = matrix(rnorm(30), nrow=3, ncol=10),
                    mode2.X = matrix(rnorm(36), nrow=4, ncol=9), 
                    mode3.X = matrix(rnorm(40), nrow=5, ncol=8),
                    resp = array(rnorm(60), dim=c(3,4,5)))
im_mat(a$mode1.X)
im_mat(a$mode2.X)
im_mat(a$mode3.X)
im_mat(a$resp[,,1])
}
\keyword{datasets}

