% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{getSublb}
\alias{getSublb}
\alias{getSublb,Arena-method}
\title{Function for calculated the substrate concentration for every organism}
\usage{
getSublb(object)

\S4method{getSublb}{Arena}(object)
}
\arguments{
\item{object}{An object of class Arena.}
}
\value{
Returns the substrate concentration for every individual in the environment with substrates as well as x and y positions as columns and rows for each organism.
}
\description{
The generic function \code{getSublb} calculates the substrate concentration for every individual in the environment based on their x and y position.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
sublb <- getSublb(arena)
}
\seealso{
\code{\link{Arena-class}}
}

