% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BallMapper.R
\name{BallMapper}
\alias{BallMapper}
\title{Create vertices and edges (with additional properties) of a Ball Mapper graph representation of the input data. Please be aware that the program will not perform any normalization on the data. As with cluster analysis we recommend that you consider whether to normalize the data prior to running the function.}
\usage{
BallMapper(points, values, epsilon)
}
\arguments{
\item{points, }{a collection of input points in a form of a data frame. These are typically points in Euclidean space. By default the Euclidean distance is used to construct the Ball Mapper.}

\item{values, }{a collection of outcome values which apply to the data points. Mean values of this variable within any given ball will be used to color the Ball Mapper graph. If it is not available, please set it to a constant array with the same length as the number of observations in the dataset.}

\item{epsilon, }{the value of radius of balls used in the Ball Mapper construction.}
}
\value{
The function returns a long list of outputs which are explained below:
vertices, comprises two binded lists: First one which contains an increasing sequence of numbers starting from 1 to the number of vertices. Each of them corresponds to a landmark point. The second one contains the number of points covered by a ball of radius epsilon centered by the following landmark points.
edges, a collection of not directed edges composed of the first and the second vertex. Ordering of vertices do not have meaning.
edges_strength, For every edge [a,b] we define its strength as the number of points that are covered by both landmarks a and b. This array contains the strength of every edge in the Ball Mapper graph.
points_covered_by_landmarks, is a list of vectors. I-th vector contains the positions of points covered by i-th landmark.
landmarks, contains a list of positions of the landmark points used to construct the balls.
coloring, is a vector having as many positions as the number of lanrmarks. It contains the averaged outcome values of the coloring variable corresponding to the points covered by each landmark.
}
\description{
Create vertices and edges (with additional properties) of a Ball Mapper graph representation of the input data. Please be aware that the program will not perform any normalization on the data. As with cluster analysis we recommend that you consider whether to normalize the data prior to running the function.
}
\examples{
var <- seq(from=0,to=6.3,by=0.1)
points <- as.data.frame( cbind( sin(var),cos(var) ) )
values <- as.data.frame( sin(var) )
epsilon <- 0.25
l <- BallMapper(points,values,epsilon)
}
