% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waitForJobs.R
\name{waitForJobs}
\alias{waitForJobs}
\title{Wait for termination of jobs on the batch system.}
\usage{
waitForJobs(reg, ids, sleep = 10, timeout = 604800,
  stop.on.error = FALSE, progressbar = TRUE)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{ids}{[\code{integer}]\cr
Vector of job ids.
Default is all submitted jobs not yet terminated.}

\item{sleep}{[\code{numeric(1)}]\cr
Seconds to sleep between status updates. Default is \code{10}.}

\item{timeout}{[\code{numeric(1)}]\cr
After waiting \code{timeout} seconds, show a message and return \code{FALSE}.
This argument may be required on some systems where, e.g., expired jobs or jobs on hold
are problematic to detect. If you don't want a timeout, set this to \code{Inf}.
Default is \code{604800} (one week).}

\item{stop.on.error}{[\code{logical(1)}]\cr
Immediately return if a job terminates with an error? Default is \code{FALSE}.}

\item{progressbar}{[\code{logical(1)}]\cr
Set to \code{FALSE} to disable the progress bar.
To disable all progress bars, see \code{\link[BBmisc]{makeProgressBar}}.}
}
\value{
[\code{logical(1)}]. Returns \code{TRUE} if all jobs terminated successfully
  and \code{FALSE} if either an error occurred or the timeout is reached.
}
\description{
Waits for termination of jobs while displaying a progress bar
containing summarizing informations of the jobs.
The following abbreviations are used in the progress bar:
\dQuote{S} for number of jobs on system, \dQuote{D} for number of
jobs successfully terminated, \dQuote{E} for number ofjobs terminated
with an R exception and \dQuote{R} for number of jobs currently running
on the system.
}
