% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{Truncated}
\alias{Truncated}
\title{Truncates a Distribution}
\usage{
Truncated(dist, lower, upper)
}
\arguments{
\item{dist}{A Julia Distribution created using \code{\link{Gamma}},
\code{\link{InverseGamma}} ...}

\item{lower}{lower bound}

\item{upper}{upper bound}
}
\value{
see \code{\link{Gamma}}
}
\description{
Truncates a Julia Distribution between `lower` and `upper`.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Truncated(Normal(0, 0.5), 0, Inf))
}

}
