% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{posterior_predictive}
\alias{posterior_predictive}
\title{Draw from the posterior predictive distribution}
\usage{
posterior_predictive(bnn, posterior_samples, x = NULL)
}
\arguments{
\item{bnn}{a BNN obtained using \code{link{BNN}}}

\item{posterior_samples}{a vector or matrix containing posterior
samples. This can be obtained using \code{\link{mcmc}}, or \code{\link{bayes_by_backprop}}
or \code{\link{find_mode}}.}

\item{x}{input variables. If `NULL` (default), training values will be used.}
}
\value{
A matrix whose columns are the posterior predictive draws.
}
\description{
Draw from the posterior predictive distribution
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sampler <- sampler.SGLD()
  ch <- mcmc(bnn, 10, 1000, sampler)
  pp <- posterior_predictive(bnn, ch$samples)
}

}
