DS.macro.inf.pgu <- function(DS.GF.obj, num.modes =1 , iters = 25, 
						 method = c("mean","mode")){
# INPUTS
#  DS.GF.obj		AutoBayes-DataCorrect object
#  num.modes		For mode inference: number of modes expected
#  method			mean finds the bootstrap mean and sd (parameteric)
#					mode finds the bootstrap mode and sd (DS)
# OUTPUTS
#  model.modes		modes of the DC prior generated by object
#  mode.sd			standard deviation of modes (generated through simulation)
#  prior.fit		dataframe of prior information for plotting
#  boot.modes/means	bootstrap mode or mean for simulation
	#require(bbmle)
	method = match.arg(method)
	switch(method,
		"mode" = {
			out <- list()				 
			modes.mat <- matrix(0, nrow = iters, ncol = num.modes)
			#needed to add a check so that it does not account for the first value
			if(sum(DS.GF.obj$LP.par^2) == 0){
				m.new = 0
				out$model.modes <- Local.Mode(DS.GF.obj$prior.fit$theta.vals, DS.GF.obj$prior.fit$parm.prior)
				if(out$model.modes[1] == DS.GF.obj$prior.fit$theta.vals[1])
						out$model.modes <- out$model.modes[-1]
				} else {
					m.new = length(DS.GF.obj$LP.par)
					out$model.modes <- Local.Mode(DS.GF.obj$prior.fit$theta.vals, DS.GF.obj$prior.fit$ds.prior)
					if(out$model.modes[1] == DS.GF.obj$prior.fit$theta.vals[1]){
						out$model.modes <- out$model.modes[-1]}
				}
			for(i in 1:iters){
			len.mode = num.modes+1
			while(len.mode != num.modes){
				par.g <- c(NA,NA)
				while(!is.finite(par.g[1])==TRUE | !is.finite(par.g[2])==TRUE){
					samps <- rDS.pgu(k = length(DS.GF.obj$obs.data), DS.GF.obj$g.par, DS.GF.obj$LP.par)  
					y.new<-NULL
					for(j in 1:length(DS.GF.obj$obs.data)){
						y.new[j] <- rpois(1, samps[j])
							}
						par.g <- gMLE.pg(y.new, start.par = DS.GF.obj$g.par)
					}
				new.LPc <- DS.prior.pgu(y.new, max.m = m.new, 
							    start.par = par.g)
				if(sum(new.LPc$LP.par^2) == 0){
					modes.new <- Local.Mode(new.LPc$prior.fit$theta.vals, new.LPc$prior.fit$parm.prior)
					} else {
					modes.new <- Local.Mode(new.LPc$prior.fit$theta.vals, new.LPc$prior.fit$ds.prior)
					}
				len.mode <- length(modes.new)
				}
		modes.mat[i,] <- modes.new
		}
		out$boot.modes <- modes.mat
		out$mode.sd <- apply(modes.mat,2,sd)
		out$prior.fit <- DS.GF.obj$prior.fit
		class(out) <- "DS_GF_macro_mode"
		return(out)	
		},
		"mean" = {
			out <- list()
			par.mean.vec <- NULL
			for(i in 1:iters){
				par.g <- c(NA,NA)
				while(!is.finite(par.g[1])==TRUE | !is.finite(par.g[2])==TRUE){
					samps <- rDS.pgu(k = length(DS.GF.obj$obs.data)[1], DS.GF.obj$g.par, DS.GF.obj$LP.par)  
					y.new<-NULL
					for(j in 1:length(DS.GF.obj$obs.data)){
						y.new[j] <- round(rpois(1, samps[j]),0)
							}
					par.g <- gMLE.pg(y.new, start.par = DS.GF.obj$g.par)
					}
				par.mean.vec[i] <- par.g[1]*par.g[2]
				}
			out$model.mean <- DS.GF.obj$g.par[1]*DS.GF.obj$g.par[2]
			out$boot.mean <- par.mean.vec
			out$mean.sd <- sd(par.mean.vec)
			out$prior.fit <- DS.GF.obj$prior.fit
			class(out) <- "DS_GF_macro_mean"
			return(out)
		}	
		)
}
