% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wendland_basis.R
\name{wendland_basis}
\alias{wendland_basis}
\title{calculate the Wendland basis function}
\usage{
wendland_basis(d, radius)
}
\arguments{
\item{d}{The distance over which to calculate the Wendland basis}

\item{radius}{The effective radius over which the Wendland basis is defined}
}
\value{
The output of the Wendland basis applied to the distance \code{d} for a given radius \code{radius}.
}
\description{
calculate the Wendland basis function
}
\examples{
layout(matrix(1:2, 1, 2))
curve(wendland_basis(sqrt(x^2), radius = 1), from = -2, to = 2)
curve(wendland_basis(sqrt(x^2), radius = 2), from = -2, to = 2)

}
