% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{metropolis_hastings_aug_ranking_pseudo}
\alias{metropolis_hastings_aug_ranking_pseudo}
\title{Metropolis-Hastings Augmented Ranking (pseudolikelihood)}
\usage{
metropolis_hastings_aug_ranking_pseudo(
  alpha,
  rho,
  n_items,
  partial_ranking,
  current_ranking,
  metric
)
}
\arguments{
\item{alpha}{Numeric value of the scale parameter}

\item{rho}{Numeric vector specifying the consensus ranking}

\item{n_items}{Integer is the number of items in a ranking}

\item{partial_ranking}{An incomplete rank sequence vector of the original observed incomplete ranking which contains NAs}

\item{current_ranking}{An complete rank sequence vector of  the proposed augmented ranking obtained from calculate_forward_probability function}

\item{metric}{A character string specifying the distance metric to use in the
Bayesian Mallows Model. Available options are \code{"footrule"},
\code{"spearman"}, \code{"cayley"}, \code{"hamming"}, \code{"kendall"}, and
\code{"ulam"}.}
}
\value{
= proposed augmented ranking or current ranking A ranking sequence vector representing proposed augmented ranking for next
        iteration of MCMC chain
}
\description{
Function to perform Metropolis-Hastings for new augmented ranking using the pseudolikelihood augmentation approach
}
