% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFr.R
\name{BFr}
\alias{BFr}
\title{Generalized replication Bayes factor}
\usage{
BFr(
  to,
  so,
  tr,
  sr,
  ss = 0,
  truncate = FALSE,
  log = FALSE,
  zo = NULL,
  zr = NULL,
  c = NULL,
  g = 0
)
}
\arguments{
\item{to}{Original effect estimate}

\item{so}{Standard error of the original effect estimate}

\item{tr}{Replication effect estimate}

\item{sr}{Standard error of the replication effect estimate}

\item{ss}{Standard devation of the sceptical prior under
\eqn{H_\mathrm{S}}{HS}. Defaults to \code{0}}

\item{truncate}{Logical indicating whether advocacy prior should be truncated
to direction of the original effect estimate (i.e., a one-sided test).
Defaults to \code{FALSE}}

\item{log}{Logical indicating whether the natural logarithm of the Bayes
factor should be returned. Defaults to \code{FALSE}}

\item{zo}{Original \emph{z}-value \code{zo} = \code{to}/\code{so} (alternative
parametrization for \code{to} and \code{so})}

\item{zr}{Replication \emph{z}-value \code{zr} = \code{tr}/\code{sr} (alternative
parametrization for \code{tr} and \code{sr})}

\item{c}{Relative variance \code{c = so^2/sr^2} (alternative parametrization
for \code{so} and \code{sr})}

\item{g}{Relative prior variance \code{g = ss^2/so^2}. Defaults to \code{0}
(alternative parametrization for \code{ss})}
}
\value{
The generalized replication Bayes factor
\eqn{\mathrm{BF}_{\mathrm{SA}}}{BF_SA}. \eqn{\mathrm{BF}_{\mathrm{SA}} <
    1}{BF_SA < 1} indicates that the data favour the advocate's hypothesis
\eqn{H_{\mathrm{A}}}{HA} (replication success), whereas
\eqn{\mathrm{BF}_{\mathrm{SA}} > 1}{BF_SA > 1} indicates that the data
favour the sceptic's hypothesis \eqn{H_{\mathrm{S}}}{HS} (replication
failure).
}
\description{
Computes the generalized replication Bayes factor
}
\details{
The generalized replication Bayes factor is the Bayes factor
contrasting the sceptic's hypothesis that the effect size is about zero
\deqn{H_{\mathrm{S}}: \theta \sim \mathrm{N}(0, \code{ss}^2)}{HS: theta ~
    N(0, ss^2)} to the advocate's hypothesis that the effect size is
compatible with its posterior distribution based on the original study
and a uniform prior \deqn{H_{\mathrm{A}}: \theta \sim f(\theta \, | \,
    \mathrm{original~study}).}{HA: theta ~ f(theta | original study).} The
standard replication Bayes factor from Verhagen and Wagenmakers (2014) is
obtained by specifying a point-null hypothesis \code{ss = 0} (the
default).

The function can be used with two input parametrizations, either on the
absolute effect scale (\code{to}, \code{so}, \code{tr}, \code{sr}, \code{ss})
or alternatively on the relative \emph{z}-scale (\code{zo}, \code{zr}, \code{c},
\code{g}). If an argument on the effect scale is missing, the \emph{z}-scale is
automatically used and the other non-missing arguments on the effect scale
ignored.
}
\examples{
to <- 2
tr <- 2.5
so <- 1
sr <- 1
BFr(to = to, so = so, tr = tr, sr = sr)
BFr(zo = to/so, zr = tr/sr, c = so^2/sr^2)

 
}
\references{
Verhagen, J. and Wagenmakers, E. J. (2014). Bayesian tests to
quantify the result of a replication attempt. Journal of Experimental
Psychology: General, 145:1457-1475. \doi{10.1037/a0036731}

Ly, A., Etz, A., Marsman, M., Wagenmakers, E. J. (2019). Replication Bayes
factors from evidence updating. Behavior Research Methods, 51(6):2498-2508.
\doi{10.3758/s13428-018-1092-x}

Pawel, S. and Held, L. (2022). The sceptical Bayes factor for the
assessment of replication success. Journal of the Royal Statistical
Society Series B: Statistical Methodology, 84(3): 879-911.
\doi{10.1111/rssb.12491}
}
\seealso{
\code{\link{BFrSMD}}, \code{\link{BFrlogOR}}
}
\author{
Samuel Pawel
}
