% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior}
\alias{prior}
\alias{prior_none}
\title{Creates a prior distribution}
\usage{
prior(
  distribution,
  parameters,
  truncation = list(lower = -Inf, upper = Inf),
  prior_weights = 1
)

prior_none(prior_weights = 1)
}
\arguments{
\item{distribution}{name of the prior distribution. The
possible options are
\describe{
\item{\code{"point"}}{for a point density characterized by a
\code{location} parameter.}
\item{\code{"normal"}}{for a normal distribution characterized
by a \code{mean} and \code{sd} parameters.}
\item{\code{"lognormal"}}{for a lognormal distribution characterized
by a \code{meanlog} and \code{sdlog} parameters.}
\item{\code{"cauchy"}}{for a Cauchy distribution characterized
by a \code{location} and \code{scale} parameters. Internally
converted into a generalized t-distribution with \code{df = 1}.}
\item{\code{"t"}}{for a generalized t-distribution characterized
by a \code{location}, \code{scale}, and \code{df} parameters.}
\item{\code{"gamma"}}{for a gamma distribution characterized
by either \code{shape} and \code{rate}, or \code{shape} and
\code{scale} parameters. The later is internally converted to
the \code{shape} and \code{rate} parametrization}
\item{\code{"invgamma"}}{for an inverse-gamma distribution
characterized by a \code{shape} and \code{scale} parameters. The
JAGS part uses a 1/gamma distribution with a shape and rate
parameter.}
\item{\code{"beta"}}{for a beta distribution
characterized by an \code{alpha} and \code{beta} parameters.}
\item{\code{"exp"}}{for an exponential distribution
characterized by either \code{rate} or \code{scale}
parameter. The later is internally converted to
\code{rate}.}
\item{\code{"uniform"}}{for a uniform distribution defined on a
range from \code{a} to \code{b}}
}}

\item{parameters}{list of appropriate parameters for a given
\code{distribution}.}

\item{truncation}{list with two elements, \code{lower} and
\code{upper}, that define the lower and upper truncation of the
distribution. Defaults to \code{list(lower = -Inf, upper = Inf)}.
The truncation is automatically set to the bounds of the support.}

\item{prior_weights}{prior odds associated with a given distribution.
The value is passed into the model fitting function, which creates models
corresponding to all combinations of prior distributions for each of
the model parameters and sets the model priors odds to the product
of its prior distributions.}
}
\value{
\code{prior} and \code{prior_none} return an object of class 'prior'.
A named list containing the distribution name, parameters, and prior weights.
}
\description{
\code{prior} creates a prior distribution.
The prior can be visualized by the \code{plot} function.
}
\examples{
# create a standard normal prior distribution
p1 <- prior(distribution = "normal", parameters = list(mean = 1, sd = 1))

# create a half-normal standard normal prior distribution
p2 <- prior(distribution = "normal", parameters = list(mean = 1, sd = 1),
truncation = list(lower = 0, upper = Inf))

# the prior distribution can be visualized using the plot function
# (see ?plot.prior for all options)
plot(p1)

}
\seealso{
\code{\link[=plot.prior]{plot.prior()}}, \link[stats]{Normal}, \link[stats]{Lognormal}, \link[stats]{Cauchy},
\link[stats]{Beta}, \link[stats]{Exponential},
\link[extraDistr]{LocationScaleT}, \link[extraDistr]{InvGamma}.
}
