% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal-distributions.R
\name{marginal_posterior}
\alias{marginal_posterior}
\title{Model-average marginal posterior distributions}
\usage{
marginal_posterior(
  samples,
  parameter,
  formula = NULL,
  at = NULL,
  prior_samples = FALSE,
  use_formula = TRUE,
  transformation = NULL,
  transformation_arguments = NULL,
  transformation_settings = FALSE,
  n_samples = 10000,
  ...
)
}
\arguments{
\item{samples}{model-averaged posterior samples created by \code{mix_posteriors()}}

\item{parameter}{parameter of interest}

\item{formula}{model formula (needs to be specified if \code{parameter} was part of a formula)}

\item{at}{named list with predictor levels of the formula for which marginalization
should be performed. If a predictor level is missing, \code{0} is used for continuous
predictors, the baseline factor level is used for factors with \code{contrast = "treatment"} prior
distributions, and the parameter is completely omitted for for factors with \code{contrast = "meandif"},}

\item{prior_samples}{whether marginal prior distributions should be generated
\code{contrast = "orthonormal"}, and \code{contrast = "independent"} levels}

\item{use_formula}{whether the parameter should be evaluated as a part of supplied formula}

\item{transformation}{transformation to be applied
to the prior distribution. Either a character
specifying one of the prepared transformations:
\describe{
\item{lin}{linear transformation in form of \code{a + b*x}}
\item{tanh}{also known as Fisher's z transformation}
\item{exp}{exponential transformation}
}, or a list containing the transformation function \code{fun},
inverse transformation function \code{inv}, and the Jacobian of
the transformation \code{jac}. See examples for details.}

\item{transformation_arguments}{a list with named arguments for
the \code{transformation}}

\item{transformation_settings}{boolean indicating whether the
settings the \code{x_seq} or \code{x_range} was specified on
the transformed support}

\item{n_samples}{number of samples to be drawn for the model-averaged
prior distribution}

\item{...}{additional arguments}
}
\value{
\code{marginal_posterior} returns a named list of mixed marginal posterior
distributions (either a vector of matrix).
#'
}
\description{
Creates marginal model-averages posterior distributions for a given
parameter based on model-averaged posterior samples and parameter name
(and formula with at specification).
}
