% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesTreePrior.R
\name{NumBotMaxDepthX}
\alias{NumBotMaxDepthX}
\title{Number of bottom nodes and depth in the general case (Case #4).}
\usage{
NumBotMaxDepthX(alpha, beta, X, depth = 0, minpart = 1, pvars = NULL,
  MIA = FALSE, missingdummy = FALSE)
}
\arguments{
\item{alpha}{base parameter of the tree prior, \eqn{\alpha \in [0,1)}.}

\item{beta}{power parameter of the tree prior, \eqn{beta \geq 0}.}

\item{X}{data.frame of the design matrix.}

\item{depth}{depth of the current node, \eqn{depth \geq 0}.}

\item{minpart}{the minimum number of bottom nodes required in one of the child to be able to split, \eqn{minpart>0}.}

\item{pvars}{vector of probabilities for the choices of variables to split (Will automatically be normalized so that the sum equal to 1). It must be twice as large as the number of variables when \eqn{missingdummy} is TRUE.}

\item{MIA}{set to TRUE if you want Missing Incorporated in Attributes (MIA) imputation to be used.}

\item{missingdummy}{set to TRUE if you have dummy coded the NAs.}
}
\value{
Returns a vector containing the number of bottom nodes and depth
}
\description{
Generate a tree and returns the number of bottom nodes and depth in the general case (Case #4).
}
\examples{
if (requireNamespace("MASS", quietly = TRUE)) {
    x1 = MASS::mcycle$times
    x1[sample(1:length(x1), 20)] <- NA
    x2= MASS::mcycle$accel
    x2[sample(1:length(x2), 20)] <- NA
    X = cbind(x1, x2)
    results1 = NumBotMaxDepthX(.95,.5, data.frame(X), minpart=5)
    X_dummies = is.na(X) + 0
    results2 = NumBotMaxDepthX(.95,.5, data.frame(cbind(X,X_dummies)), minpart=5, MIA=TRUE, 
    missingdummy=TRUE)
}
}
\references{
Twala, B. E. T. H., Jones, M. C., & Hand, D. J. (2008). \emph{Good methods for coping with missing data in decision trees.} Pattern Recognition Letters, 29(7), 950-956.
}
\seealso{
\code{\link{NumBotMaxDepth_inf}}, \code{\link{NumBotMaxDepth}}
}

