% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_square_goodness_of_fit.R
\name{p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit}
\alias{p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit}
\title{Get the Chi square values}
\usage{
p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit(StanS4class,
  dig = 3, Colour = TRUE, plot.replicated.points = FALSE)
}
\arguments{
\item{StanS4class}{This is an output of \code{rstan::stan()}.}

\item{dig}{An argument of \code{rstan::stan()} in which it is named \code{iter}.  It means the Significant digits, used in stan Cancellation.
default = 5,}

\item{Colour}{TRUE or FALSE. Colour of curves.}

\item{plot.replicated.points}{TRUE or FALSE. If true, then plot replicated points (hits, false alarms) by the scatter plot. This process will takes a long times. So if user has no time, then \code{FALSE} will help you.}
}
\value{
the Chi square values with indexed by the all possible pair of replicated data and MCMC samples.
}
\description{
Get the Chi square values with indexed by the all possible pair of replicated data and MCMC samples.
}
\details{
Here, we briefly review how to get the chi square samples.

First, Let f(y|s) be a model (likelihood) with future data y and model parameter s. Let p(s|D) be a posterior probability density for given data D. In this situation, the Hamiltonian Monte Carlo method is performed to get the MCMC samples, say s1, s2, s3,...,sN. Alternatively, we get the sequence of models f(y| s1), f(y| s2), f(y| s3),...,f(y| sN). To get the samples y1, y2,...,yN from the posterior probability distribution, we merely draw the y1, y2,...,yN from f(y| s1), f(y| s2), f(y| s3),...,f(y| sN), respectively. That is for all I yi is drawn from the distribution f(y|si).

In this manner we get the two sequence of samples, one is from the posterior distribution and one is the posterior predictive distribution. Using these two kind of samples, we can calculate the test statistics as the Bayesian manner. That is, in frequentist method, the test statistics are calculated by the fixed model parameters, such as the maximal likelihood estimators. However, in Bayesian context, the parameter is not deterministic and hence we should calculate test statistics with the posterior measure. To accomplish this task, this package include the function.
}
\examples{
 \donttest{
# First, fit the model to data. The number of sampling of the Hamiltonian Monte Carlo
# methods should be a little number, if user computer has low ability,
# since the calculation of the posterior predictive p values is heavy.


 fit <- fit_Bayesian_FROC(BayesianFROC::dataList.Chakra.1 ,ite = 1111)



#  Second, extract the posterior predictive p value from the output.
#  If it is greater than, e.g., 0.05, then your model cannot be said that
#   it is not fitted to your data.

 output <-  p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit(fit)


 output$p.values.for.chisquare
# If user has no time, then  plot.replicated.points=FALSE will help you.
# By setting FALSE, the replicated data from the posterior predictive
# distribution does not draw, and hence the running time of function become shorter.

 TPs.FPs <- p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit(fit,
                                   plot.replicated.points =  FALSE)


#  If user want to use the scatter plots of hits and false alarms from the posterior
#  predictive distribution for the submission, then the color plot is not appropriate.
#  So, by setting the argument Colour = FALSE, the scatter plot become black and white.
#  So, user can use this scatter plot for submission.


 p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit(fit,Colour = FALSE)




# Since p values are depend on data only, so it is better to show this dependency more
# explicitly as follows;

   p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit(
   fit_Bayesian_FROC(dataList.High)
    )




       #    Close the graphic device

       Close_all_graphic_devices()


}# dottest
}
\seealso{
get_samples_from_Posterior_Predictive_distribution,
chi_square_goodness_of_fit_from_input_all_param
}
