% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_srsc_per_image_test.R
\name{fit_srsc_per_image_test}
\alias{fit_srsc_per_image_test}
\title{fit a model to data in the case of
Single reader and Single modality (srsc).}
\usage{
fit_srsc_per_image_test(dataList, new.imaging.device = TRUE,
  dataList.Name = "", DrawCurve = TRUE, PreciseLogLikelihood = TRUE,
  Drawcol = TRUE, make.csv.file.to.draw.curve = FALSE,
  mesh.for.drawing.curve = 10000, summary = TRUE,
  DrawFROCcurve = TRUE, DrawAFROCcurve = FALSE, DrawCFPCTP = TRUE,
  cha = 4, ite = 3000, dig = 5, war = floor(ite/5), see = 1234)
}
\arguments{
\item{dataList}{it should include  \code{f, h, NL, NI, C}.
The detail of these dataset, please see the endowed datasets.
Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
should not include its each confidence level in \code{dataList}}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{dataList.Name}{This is not for user, but the author for this package development.}

\item{DrawCurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the curve is to be drawn. TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}.
The reason why the author make this variable \code{DrawCurve} is that it takes long time in MRMC case to draw curves, and thus default value is \code{FALSE} in the case of MRMC data.}

\item{PreciseLogLikelihood}{Logical, that is \code{TRUE} or \code{FALSE}. If \code{PreciseLogLikelihood  = TRUE}(default), then Stan calculates the precise log likelihood with target formulation.

If \code{PreciseLogLikelihood  = FALSE}, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.
In past, I distinct the stan file, one is target formulation and the another is not. But non-target formulation cause some Jacobian warnning, thus I made all stanfile with target formulation when I uploaded to CRAN. Thus this variable is now meaningless.}

\item{Drawcol}{Logical: \code{TRUE} of \code{FALSE}. Whether the (A)FROC curve is to be drawn  by using color of dark theme. The default value is a \code{TRUE}.}

\item{make.csv.file.to.draw.curve}{Logical: \code{TRUE} of \code{FALSE}. Whether  to create a csv file. If \code{TRUE} then csv file is created in your desktop to draw an FROC curve and cumulative hits and false alarms by scatter plot. Default is  \code{FALSE} since it took times to create csv files.}

\item{mesh.for.drawing.curve}{An integer indicating number of dots drawing the curves, default =10000.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the  AFROC curve is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFPCTP points are  to be drawn.}

\item{cha}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \strong{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{chains}.  A positive integer representing   the number of chains generated by Hamiltonian Monte Carlo method,
and, default = 1.}

\item{ite}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \strong{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}

\item{dig}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \strong{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{...??}.   A positive integer representing   the Significant digits, used in stan Cancellation.
default = 5,}

\item{war}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \strong{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{warmup}.  A positive integer representing the Burn in period, which must be less than \code{ite}. Defaults to
war = floor(ite/5)=10000/5=2000,}

\item{see}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \strong{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{seed}.  A positive integer representing  seed used in stan,
default = 1234567.}
}
\value{
An S4 object of class \code{stanfitExtended}.
}
\description{
Build a fitted model object to data in case of  single reader
and single modality data \code{dataList}. FPF is per image.
}
\details{
Revised 2019.Jun. 17
}
\examples{
\donttest{
#First, prepare the example data from this package.



        dat  <- get(data("dataList.Chakra.1"))




#Second, fit a model to data named "dat"





           fit <-  fit_srsc_per_image_test(dat)







#      Close the graphic device to avoid errors in R CMD check.

         Close_all_graphic_devices()


}# dottest
}
