% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortAUC.R
\name{sortAUC}
\alias{sortAUC}
\title{Prints a Ranking for AUCs for MRMC Data}
\usage{
sortAUC(StanS4class, digits = 3, simple = FALSE)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

It can be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{digits}{To be passed to \code{round()} for AUC, to determine the significant digits of AUCs.}

\item{simple}{Logical,  \code{TRUE} or  \code{FALSE}. If \code{TRUE}, then it is simple.

  @export}
}
\value{
A data-frame, representing sorted ranking of modality ID and its AUC. Revised 2019 Sept 9
}
\description{
prints a modality ranking according to their AUCs.
}
\details{
This is a ranking. Sort a data-frame involving AUC and corresponding modality IDs.
}
\examples{

 \dontrun{
#========================================================================================
#            1)      Fit a model to an MRMC data-set named dd
#========================================================================================

                    fit <- fit_Bayesian_FROC(
                                                ite  = 1111,
                                             summary = FALSE,
                                                 cha = 1,
                                            dataList = dd
                                             )



#========================================================================================
#            2)         Sort the AUC and make a ranking table
#========================================================================================



                              sortAUC(fit)



# Then, a ranking table will appear.

                                                               # Reviesed 2019 Sept 9

 }



}
