% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_MRMC.R
\name{summarize_MRMC}
\alias{summarize_MRMC}
\title{Summarize the estimates for MRMC case}
\usage{
summarize_MRMC(StanS4class, dig = 3)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{stanfit}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

It can be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{dig}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{...??}.   A positive integer representing   the Significant digits, used in stan Cancellation.
Default = 5,}
}
\value{
Nothing
}
\description{
Summarize the estimates for MRMC case
}
\examples{
\dontrun{
   fit <- fit_Bayesian_FROC(
           dataList.Chakra.Web.orderd,
           ite = 1111,
           summary =FALSE
           )

   summarize_MRMC(fit)


}# dottest
}
