% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_latent_distribution.R
\name{draw_latent_signal_distribution}
\alias{draw_latent_signal_distribution}
\title{Visualization of Latent Gaussians ( Signal Distribution)}
\usage{
draw_latent_signal_distribution(
  StanS4class,
  dark_theme = TRUE,
  dig = 3,
  mesh = 1000,
  new.imaging.device = TRUE,
  hit.rate = TRUE,
  false.alarm.rate = FALSE,
  both.hit.and.false.rate = FALSE,
  density = 22,
  color = TRUE,
  mathmatical.symbols = TRUE,
  type = 3,
  summary = FALSE
)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{stanfit}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

To be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{dark_theme}{TRUE or FALSE}

\item{dig}{A positive integer, indicating the digit for numbers in the R console.}

\item{mesh}{Mesh for painting the area}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{hit.rate}{whether draws it. Default is \code{TRUE}.}

\item{false.alarm.rate}{whether draws it. Default is \code{TRUE}.}

\item{both.hit.and.false.rate}{whether draws it. Default is \code{TRUE}.}

\item{density}{A natural number, indicating the density of shading lines, in lines per inch.}

\item{color}{A color region is selected from black and white only. For more colors, put \code{FALSE}. For publication, the mono color is allowed in many case, so the author made this for such publication.}

\item{mathmatical.symbols}{A logical, whether legend is in plot.}

\item{type}{An integer, for the color of background and etc.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\value{
Information of Latent Gaussians, such as mean and S.D. of the signal distributions and thresholds.
}
\description{
Plot the posterior mean
 of  model parameter \eqn{\theta} and
  the parameter of the latent function, i.e.
 the normal distribution denoted by \eqn{ Gaussian(z|\mu,\sigma)}
 with posterior mean estimates of its mean \eqn{\mu} and
 standard deviation \eqn{\sigma}.
}
\details{
Our FROC model
use a latent Gaussian random variable to determine hit rates.
That is, each hit rate is defined as follows;



\deqn{ p_5(z_1,...z_C; \mu, \sigma) = \int_{z5}^{\infty} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_4(z_1,...z_C; \mu, \sigma) = \int_{z4}^{z5} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_3(z_1,...z_C; \mu, \sigma) = \int_{z3}^{z4} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_2(z_1,...z_C; \mu, \sigma) = \int_{z2}^{z3} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_1(z_1,...z_C; \mu, \sigma) = \int_{z1}^{z2} Gaussian(z|\mu,\sigma)dz}




 For example, in the following data,
 the number of hit data with the most
  highest confidence level 5 is regarded as an sample from the Binomial distribution of hit rate
   \eqn{p_5(z_1,...z_C; \mu, \sigma) = \int_{z5}^{\infty} Gaussian(z|\mu,\sigma)dz}
   with
 Bernoulli trial number is \code{NL=142}.




 So, this Gaussian distribution determines hit rate, and this function \code{draw_latent_signal_distribution()} plot
 this Gaussian distribution \eqn{ Gaussian(z|\mu,\sigma)}.
 And a reference distribution is  the standard Gaussian and do not confuse that
 it is not the noise distribution, but only reference.

 The noise distribution (denoted by \eqn{d \log \Phi})  determines the
 False alarm rates in the similar manner and plotted by using a line of dots.
 The author thinks the standard Gaussian is more comfortable to compare or confirm the shape of  \eqn{ Gaussian(z|\mu,\sigma)} and
 thus, the author implement it in the \code{\link{draw_latent_signal_distribution}()}.

 One would want to see the signal distribution and noise distribution simultaneously, then use the function \code{\link{draw_latent_noise_distribution}()}.
}
\examples{
\dontrun{
#========================================================================================
#   Shape of signal distribution strongly influences the value of AUC, so in the following
#   the author shows how it affects the estimates of AUCs.
#    We consider two data examples, one is a low AUC and the other is a high AUC.
#   In the high AUC case, the Signal Gaussain will be low variance and
#   in the low AUC case, the variance will desperse.  2019 August 4, 2019 Dec 17
#========================================================================================


#            ----- High AUC case --------

     viewdata(dataList.High)

     fit.High <- fit_Bayesian_FROC(dataList.High,ite=111)

     draw_latent_signal_distribution(fit.High)




#            ----- Low AUC case --------

     viewdata(dataList.Low)

     fit.Low <- fit_Bayesian_FROC(dataList.Low)

     draw_latent_signal_distribution(fit.Low)




#--------------------------------------------------------------------------------------
#                         2)      For submission (without color)
#--------------------------------------------------------------------------------------





     fit <-    fit_Bayesian_FROC(
                                 dataList = dataList.Chakra.1.with.explantation
                                 )




# With legends


     draw_latent_signal_distribution(fit,
                   dark_theme  = FALSE,
                   color = TRUE,
                   density = 11
                   )



#' Without legends
draw_latent_signal_distribution(fit,
                                dark_theme           = FALSE,
                                color               = TRUE,
                                mathmatical.symbols = FALSE
)
             # 2019 Sept. 5
             # 2020 March 12



     Close_all_graphic_devices() # 2020 August

}# dottest
}
\seealso{
\code{\link{draw_latent_noise_distribution}()}
Note that the difference of \code{\link{draw_latent_noise_distribution}()} and
  \code{draw_latent_signal_distribution()} is that the lator use the standard Gaussian for the reference distribution and
  former uses the \eqn{d \log \Phi()} for the reference distribution.

  So, the  old version \code{draw_latent_signal_distribution()}  is also important and I like this old version also.
  Anyway who read this, I think my package size is very large,....ha,,,,I have to reduce it,....but how?
}
