% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_sampsize.R
\name{bayes_power}
\alias{bayes_power}
\title{Determine the 'power' for a Bayesian hypothesis test}
\usage{
bayes_power(n, h1, h2, m1, m2, ngroup = NULL, comp = NULL,
  bound1 = 1, bound2 = 1/bound1, datasets = 1000, nsamp = 1000,
  seed = NULL)
}
\arguments{
\item{n}{A number. The sample size}

\item{h1}{A constraint matrix defining H1}

\item{h2}{A constraint matrix defining H2}

\item{m1}{A vector of expected population means under H1 (standardized)}

\item{m2}{A vector of expected populations means under H2 (standardized)
\code{m2} must be of same length as \code{m1}}

\item{ngroup}{A number or \code{NULL}. The number of groups
If \code{NULL} the number of groups is determined from the length of \code{m1}}

\item{comp}{A vector or \code{NULL}. The complexity of H1 and H2. If
\code{NULL} the complexity is also estimated}

\item{bound1}{A number. The boundary above which BF12 favors H1}

\item{bound2}{A number. The boundary below which BF12 favors H2}

\item{datasets}{A number. The number of datasets to compute the error probabilities}

\item{nsamp}{A number. The number of prior or posterior samples to determine the
fit and complexity}

\item{seed}{A number. The random seed to be set}
}
\value{
The Type 1, Type 2, Decision error and Area of Indecision probability and
the median BF12s under H1 and H2
}
\description{
Determine the 'power' for a Bayesian hypothesis test
}
\examples{
# Short example WITH SMALL AMOUNT OF SAMPLES
h1 <- matrix(c(1,-1,0,0,1,-1), nrow= 2, byrow= TRUE)
h2 <- "c"
m1 <- c(.4,.2,0)
m2 <- c(.2,0,.1)
bayes_power(40, h1, h2, m1, m2, datasets = 50, nsamp = 50)
\donttest{
# Example 1 H1 vs Hc
h1 <- matrix(c(1,-1,0,0,1,-1), nrow= 2, byrow= TRUE)
h2 <- "c"
m1 <- c(.4,.2,0)
m2 <- c(.2,0,.1)
bayes_power(40, h1, h2, m1, m2, datasets = 500, nsamp = 500)

# Example 2 H1 vs H2
h1 <- matrix(c(1,-1,0,0,0,1,-1,0,0,0,1,-1), nrow= 3, byrow= TRUE)
h2 <- matrix(c(0,-1,1,0,0,1,0,-1,-1,0,0,1), nrow = 3, byrow= TRUE)
m1 <- c(.7,.3,.1,0)
m2 <- c(0,.4,.5,.1)
bayes_power(40, h1, h2, m1, m2, datasets = 500, nsamp = 500)
}
}
