/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.LogTricks;
import dr.math.MathUtils;
import dr.math.distributions.NormalDistribution;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.util.DataTable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class AntigenicLikelihood
extends AbstractModelLikelihood
implements Citable {
    private static final boolean CHECK_INFINITE = false;
    private static final boolean USE_THRESHOLDS = true;
    private static final boolean USE_INTERVALS = true;
    public static final String ANTIGENIC_LIKELIHOOD = "antigenicLikelihood";
    private static final int VIRUS_ISOLATE = 0;
    private static final int VIRUS_STRAIN = 1;
    private static final int VIRUS_DATE = 2;
    private static final int SERUM_ISOLATE = 3;
    private static final int SERUM_STRAIN = 4;
    private static final int SERUM_DATE = 5;
    private static final int TITRE = 6;
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private final List<String> virusNames = new ArrayList<String>();
    private final List<String> serumNames = new ArrayList<String>();
    private final List<Double> virusDates = new ArrayList<Double>();
    private final List<Double> serumDates = new ArrayList<Double>();
    private final int mdsDimension;
    private final double intervalWidth;
    private final Parameter mdsPrecisionParameter;
    private final Parameter locationDriftParameter;
    private final Parameter virusDriftParameter;
    private final Parameter serumDriftParameter;
    private final MatrixParameter virusLocationsParameter;
    private final MatrixParameter serumLocationsParameter;
    private final Parameter virusOffsetsParameter;
    private final Parameter serumOffsetsParameter;
    private final CompoundParameter tipTraitsParameter;
    private int[] tipIndices;
    private final Parameter virusAviditiesParameter;
    private final Parameter serumPotenciesParameter;
    private final Parameter serumBreadthsParameter;
    private double logLikelihood = 0.0;
    private boolean likelihoodKnown = false;
    private final boolean[] virusLocationChanged;
    private final boolean[] serumLocationChanged;
    private final boolean[] serumEffectChanged;
    private final boolean[] virusEffectChanged;
    private double[] logLikelihoods;
    private double[] storedLogLikelihoods;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String FILE_NAME = "fileName";
        public static final String TIP_TRAIT = "tipTrait";
        public static final String VIRUS_LOCATIONS = "virusLocations";
        public static final String SERUM_LOCATIONS = "serumLocations";
        public static final String MDS_DIMENSION = "mdsDimension";
        public static final String MERGE_SERUM_ISOLATES = "mergeSerumIsolates";
        public static final String DRIFT_INITIAL_LOCATIONS = "driftInitialLocations";
        public static final String INTERVAL_WIDTH = "intervalWidth";
        public static final String MDS_PRECISION = "mdsPrecision";
        public static final String LOCATION_DRIFT = "locationDrift";
        public static final String VIRUS_DRIFT = "virusDrift";
        public static final String SERUM_DRIFT = "serumDrift";
        public static final String VIRUS_AVIDITIES = "virusAvidities";
        public static final String SERUM_POTENCIES = "serumPotencies";
        public static final String SERUM_BREADTHS = "serumBreadths";
        public static final String VIRUS_OFFSETS = "virusOffsets";
        public static final String SERUM_OFFSETS = "serumOffsets";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("fileName", false, "The name of the file containing the assay table"), AttributeRule.newIntegerRule("mdsDimension", false, "The dimension of the space for MDS"), AttributeRule.newBooleanRule("mergeSerumIsolates", true, "Should multiple serum isolates from the same strain have their locations merged (defaults to false)"), AttributeRule.newDoubleRule("intervalWidth", true, "The width of the titre interval in log 2 space"), AttributeRule.newDoubleRule("driftInitialLocations", true, "The degree to drift initial virus and serum locations, defaults to 0.0"), new ElementRule("tipTrait", CompoundParameter.class, "Optional parameter of tip locations from the tree", true), new ElementRule("virusLocations", MatrixParameter.class, "Parameter of locations of all virus"), new ElementRule("serumLocations", MatrixParameter.class, "Parameter of locations of all sera"), new ElementRule("virusOffsets", Parameter.class, "Optional parameter for virus dates to be stored", true), new ElementRule("serumOffsets", Parameter.class, "Optional parameter for serum dates to be stored", true), new ElementRule("serumPotencies", Parameter.class, "Optional parameter for serum potencies", true), new ElementRule("serumBreadths", Parameter.class, "Optional parameter for serum breadths", true), new ElementRule("virusAvidities", Parameter.class, "Optional parameter for virus avidities", true), new ElementRule("mdsPrecision", Parameter.class, "Parameter for precision of MDS embedding"), new ElementRule("locationDrift", Parameter.class, "Optional parameter for drifting locations with time", true), new ElementRule("virusDrift", Parameter.class, "Optional parameter for drifting only virus locations, overrides locationDrift", true), new ElementRule("serumDrift", Parameter.class, "Optional parameter for drifting only serum locations, overrides locationDrift", true)};

        @Override
        public String getParserName() {
            return AntigenicLikelihood.ANTIGENIC_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DataTable<String[]> dataTable;
            String string = xMLObject.getStringAttribute(FILE_NAME);
            try {
                dataTable = DataTable.Text.parse(new FileReader(string), true, false);
            }
            catch (IOException iOException) {
                throw new XMLParseException("Unable to read assay data from file: " + iOException.getMessage());
            }
            System.out.println("Loaded HI table file: " + string);
            boolean bl = xMLObject.getAttribute(MERGE_SERUM_ISOLATES, false);
            int n = xMLObject.getIntegerAttribute(MDS_DIMENSION);
            double d = 0.0;
            if (xMLObject.hasAttribute(INTERVAL_WIDTH)) {
                d = xMLObject.getDoubleAttribute(INTERVAL_WIDTH);
            }
            double d2 = 0.0;
            if (xMLObject.hasAttribute(DRIFT_INITIAL_LOCATIONS)) {
                d2 = xMLObject.getDoubleAttribute(DRIFT_INITIAL_LOCATIONS);
            }
            CompoundParameter compoundParameter = null;
            if (xMLObject.hasChildNamed(TIP_TRAIT)) {
                compoundParameter = (CompoundParameter)xMLObject.getElementFirstChild(TIP_TRAIT);
            }
            MatrixParameter matrixParameter = null;
            if (xMLObject.hasChildNamed(VIRUS_LOCATIONS)) {
                matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(VIRUS_LOCATIONS);
            }
            MatrixParameter matrixParameter2 = null;
            if (xMLObject.hasChildNamed(SERUM_LOCATIONS)) {
                matrixParameter2 = (MatrixParameter)xMLObject.getElementFirstChild(SERUM_LOCATIONS);
            }
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(MDS_PRECISION);
            Parameter parameter2 = null;
            if (xMLObject.hasChildNamed(LOCATION_DRIFT)) {
                parameter2 = (Parameter)xMLObject.getElementFirstChild(LOCATION_DRIFT);
            }
            Parameter parameter3 = null;
            if (xMLObject.hasChildNamed(VIRUS_DRIFT)) {
                parameter3 = (Parameter)xMLObject.getElementFirstChild(VIRUS_DRIFT);
            }
            Parameter parameter4 = null;
            if (xMLObject.hasChildNamed(SERUM_DRIFT)) {
                parameter4 = (Parameter)xMLObject.getElementFirstChild(SERUM_DRIFT);
            }
            Parameter parameter5 = null;
            if (xMLObject.hasChildNamed(VIRUS_OFFSETS)) {
                parameter5 = (Parameter)xMLObject.getElementFirstChild(VIRUS_OFFSETS);
            }
            Parameter parameter6 = null;
            if (xMLObject.hasChildNamed(SERUM_OFFSETS)) {
                parameter6 = (Parameter)xMLObject.getElementFirstChild(SERUM_OFFSETS);
            }
            Parameter parameter7 = null;
            if (xMLObject.hasChildNamed(SERUM_POTENCIES)) {
                parameter7 = (Parameter)xMLObject.getElementFirstChild(SERUM_POTENCIES);
            }
            Parameter parameter8 = null;
            if (xMLObject.hasChildNamed(SERUM_BREADTHS)) {
                parameter8 = (Parameter)xMLObject.getElementFirstChild(SERUM_BREADTHS);
            }
            Parameter parameter9 = null;
            if (xMLObject.hasChildNamed(VIRUS_AVIDITIES)) {
                parameter9 = (Parameter)xMLObject.getElementFirstChild(VIRUS_AVIDITIES);
            }
            AntigenicLikelihood antigenicLikelihood = new AntigenicLikelihood(n, parameter, parameter2, parameter3, parameter4, matrixParameter, matrixParameter2, compoundParameter, parameter5, parameter6, parameter7, parameter8, parameter9, dataTable, bl, d, d2);
            Logger.getLogger("dr.evomodel").info("Using EvolutionaryCartography model. Please cite:\n" + Citable.Utils.getCitationString(antigenicLikelihood));
            return antigenicLikelihood;
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of immunological assay data such as Hemagglutinin inhibition (HI) given vectors of coordinatesfor viruses and sera/antisera in some multidimensional 'antigenic' space.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return AntigenicLikelihood.class;
        }
    };

    public AntigenicLikelihood(int n, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, MatrixParameter matrixParameter, MatrixParameter matrixParameter2, CompoundParameter compoundParameter, Parameter parameter5, Parameter parameter6, Parameter parameter7, Parameter parameter8, Parameter parameter9, DataTable<String[]> dataTable, boolean bl, double d, double d2) {
        super(ANTIGENIC_LIKELIHOOD);
        double d3;
        Object object;
        this.intervalWidth = d;
        boolean bl2 = d > 0.0;
        int n2 = 0;
        double d4 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dataTable.getRowCount(); ++i) {
            double d5;
            boolean bl3;
            boolean bl4;
            int n3;
            double d6;
            int n4;
            block20: {
                object = dataTable.getRow(i);
                String object2 = object[1];
                d3 = Double.parseDouble((String)object[2]);
                n4 = this.virusNames.indexOf(object2);
                if (n4 == -1) {
                    this.virusNames.add(object2);
                    this.virusDates.add(d3);
                    n4 = this.virusNames.size() - 1;
                }
                Object object3 = "";
                object3 = bl ? object[4] : object[3];
                d6 = Double.parseDouble((String)object[5]);
                n3 = this.serumNames.indexOf(object3);
                if (n3 == -1) {
                    this.serumNames.add((String)object3);
                    this.serumDates.add(d6);
                    n3 = this.serumNames.size() - 1;
                }
                bl4 = false;
                bl3 = false;
                d5 = Double.NaN;
                if (((String)object[6]).length() > 0) {
                    try {
                        d5 = Double.parseDouble((String)object[6]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (((String)object[6]).contains("<")) {
                            d5 = Double.parseDouble(((String)object[6]).replace("<", ""));
                            bl4 = true;
                            bl3 = true;
                            ++n2;
                        }
                        if (!((String)object[6]).contains(">")) break block20;
                        d5 = Double.parseDouble(((String)object[6]).replace(">", ""));
                        bl4 = true;
                        bl3 = false;
                        ++n2;
                    }
                }
            }
            if (d6 < d4) {
                d4 = d6;
            }
            if (d3 < d4) {
                d4 = d3;
            }
            MeasurementType measurementType = bl4 ? MeasurementType.THRESHOLD : (bl2 ? MeasurementType.INTERVAL : MeasurementType.POINT);
            Measurement measurement = new Measurement(n4, n3, d3, d6, measurementType, d5, bl3);
            this.measurements.add(measurement);
        }
        double[] dArray = new double[this.serumNames.size()];
        for (Measurement measurement : this.measurements) {
            d3 = measurement.log2Titre;
            if (Double.isNaN(d3)) {
                d3 = measurement.log2Titre;
            }
            if (!(d3 > dArray[measurement.serum])) continue;
            dArray[measurement.serum] = d3;
        }
        this.mdsDimension = n;
        this.mdsPrecisionParameter = parameter;
        this.addVariable(parameter);
        this.locationDriftParameter = parameter2;
        if (this.locationDriftParameter != null) {
            this.addVariable(parameter2);
        }
        this.virusDriftParameter = parameter3;
        if (this.virusDriftParameter != null) {
            this.addVariable(parameter3);
        }
        this.serumDriftParameter = parameter4;
        if (this.serumDriftParameter != null) {
            this.addVariable(parameter4);
        }
        this.virusLocationsParameter = matrixParameter;
        if (this.virusLocationsParameter != null) {
            this.setupLocationsParameter(matrixParameter, this.virusNames);
        }
        this.serumLocationsParameter = matrixParameter2;
        if (this.serumLocationsParameter != null) {
            this.setupLocationsParameter(matrixParameter2, this.serumNames);
        }
        this.tipTraitsParameter = compoundParameter;
        if (compoundParameter != null) {
            this.setupTipTraitsParameter(this.tipTraitsParameter, this.virusNames);
        }
        this.virusOffsetsParameter = parameter5;
        if (parameter5 != null) {
            this.setupOffsetsParameter(parameter5, this.virusNames, this.virusDates, d4);
        }
        this.serumOffsetsParameter = parameter6;
        if (parameter6 != null) {
            this.setupOffsetsParameter(parameter6, this.serumNames, this.serumDates, d4);
        }
        this.serumPotenciesParameter = this.setupSerumPotencies(parameter7, dArray);
        this.serumBreadthsParameter = this.setupSerumBreadths(parameter8);
        this.virusAviditiesParameter = this.setupVirusAvidities(parameter9);
        object = new StringBuilder();
        ((StringBuilder)object).append("\tAntigenicLikelihood:\n");
        ((StringBuilder)object).append("\t\t" + this.virusNames.size() + " viruses\n");
        ((StringBuilder)object).append("\t\t" + this.serumNames.size() + " sera\n");
        ((StringBuilder)object).append("\t\t" + this.measurements.size() + " assay measurements\n");
        ((StringBuilder)object).append("\t\t" + n2 + " thresholded measurements\n");
        if (bl2) {
            ((StringBuilder)object).append("\n\t\tAssuming a log 2 measurement interval width of " + d + "\n");
        }
        Logger.getLogger("dr.evomodel").info(((StringBuilder)object).toString());
        this.virusLocationChanged = new boolean[this.virusLocationsParameter.getParameterCount()];
        this.serumLocationChanged = new boolean[this.serumLocationsParameter.getParameterCount()];
        this.virusEffectChanged = new boolean[this.virusNames.size()];
        this.serumEffectChanged = new boolean[this.serumNames.size()];
        this.logLikelihoods = new double[this.measurements.size()];
        this.storedLogLikelihoods = new double[this.measurements.size()];
        this.setupInitialLocations(d2);
        this.makeDirty();
    }

    private Parameter setupVirusAvidities(Parameter parameter) {
        if (parameter != null) {
            parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, Double.MIN_VALUE, 1));
            parameter.setDimension(this.virusNames.size());
            this.addVariable(parameter);
            String[] stringArray = new String[this.virusNames.size()];
            this.virusNames.toArray(stringArray);
            parameter.setDimensionNames(stringArray);
            for (int i = 0; i < this.virusNames.size(); ++i) {
                parameter.setParameterValueQuietly(i, 0.0);
            }
        }
        return parameter;
    }

    private Parameter setupSerumPotencies(Parameter parameter, double[] dArray) {
        if (parameter == null) {
            parameter = new Parameter.Default("serumPotencies");
        } else {
            parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
            this.addVariable(parameter);
        }
        parameter.setDimension(this.serumNames.size());
        String[] stringArray = new String[this.serumNames.size()];
        this.serumNames.toArray(stringArray);
        parameter.setDimensionNames(stringArray);
        for (int i = 0; i < dArray.length; ++i) {
            parameter.setParameterValueQuietly(i, dArray[i]);
        }
        return parameter;
    }

    private Parameter setupSerumBreadths(Parameter parameter) {
        if (parameter != null) {
            parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
            parameter.setDimension(this.serumNames.size());
            this.addVariable(parameter);
            String[] stringArray = new String[this.serumNames.size()];
            this.serumNames.toArray(stringArray);
            parameter.setDimensionNames(stringArray);
            for (int i = 0; i < this.serumNames.size(); ++i) {
                parameter.setParameterValueQuietly(i, 1.0);
            }
        }
        return parameter;
    }

    protected void setupLocationsParameter(MatrixParameter matrixParameter, List<String> list) {
        matrixParameter.setColumnDimension(this.mdsDimension);
        matrixParameter.setRowDimension(list.size());
        for (int i = 0; i < list.size(); ++i) {
            matrixParameter.getParameter(i).setId(list.get(i));
        }
        this.addVariable(matrixParameter);
    }

    private void setupOffsetsParameter(Parameter parameter, List<String> list, List<Double> list2, double d) {
        parameter.setDimension(list.size());
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        parameter.setDimensionNames(stringArray);
        for (int i = 0; i < list.size(); ++i) {
            Double d2 = list2.get(i) - new Double(d);
            if (d2 == null) {
                throw new IllegalArgumentException("Date missing for strain: " + list.get(i));
            }
            parameter.setParameterValue(i, d2);
        }
        this.addVariable(parameter);
    }

    private void setupTipTraitsParameter(CompoundParameter compoundParameter, List<String> list) {
        int n;
        this.tipIndices = new int[list.size()];
        for (n = 0; n < list.size(); ++n) {
            this.tipIndices[n] = -1;
        }
        for (n = 0; n < compoundParameter.getParameterCount(); ++n) {
            Parameter parameter = compoundParameter.getParameter(n);
            String string = parameter.getParameterName();
            int n2 = this.findStrain(string, list);
            if (n2 == -1) continue;
            if (this.tipIndices[n2] != -1) {
                throw new IllegalArgumentException("Duplicated tip name: " + string);
            }
            this.tipIndices[n2] = n;
        }
    }

    private final int findStrain(String string, List<String> list) {
        int n = 0;
        for (String string2 : list) {
            if (string.startsWith(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void setupInitialLocations(double d) {
        int n;
        double d2;
        double d3;
        int n2;
        for (n2 = 0; n2 < this.virusLocationsParameter.getParameterCount(); ++n2) {
            d3 = 0.0;
            if (this.virusOffsetsParameter != null) {
                d3 = d * this.virusOffsetsParameter.getParameterValue(n2);
            }
            d2 = MathUtils.nextGaussian() + d3;
            this.virusLocationsParameter.getParameter(n2).setParameterValue(0, d2);
            if (this.mdsDimension <= 1) continue;
            for (n = 1; n < this.mdsDimension; ++n) {
                d2 = MathUtils.nextGaussian();
                this.virusLocationsParameter.getParameter(n2).setParameterValue(n, d2);
            }
        }
        for (n2 = 0; n2 < this.serumLocationsParameter.getParameterCount(); ++n2) {
            d3 = 0.0;
            if (this.serumOffsetsParameter != null) {
                d3 = d * this.serumOffsetsParameter.getParameterValue(n2);
            }
            d2 = MathUtils.nextGaussian() + d3;
            this.serumLocationsParameter.getParameter(n2).setParameterValue(0, d2);
            if (this.mdsDimension <= 1) continue;
            for (n = 1; n < this.mdsDimension; ++n) {
                d2 = MathUtils.nextGaussian();
                this.serumLocationsParameter.getParameter(n2).setParameterValue(n, d2);
            }
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.virusLocationsParameter) {
            if (n != -1) {
                int n2 = n / this.mdsDimension;
                this.virusLocationChanged[n2] = true;
                if (this.tipTraitsParameter != null && this.tipIndices[n2] != -1) {
                    Parameter parameter = this.virusLocationsParameter.getParameter(n2);
                    Parameter parameter2 = this.tipTraitsParameter.getParameter(this.tipIndices[n2]);
                    int n3 = n % this.mdsDimension;
                    parameter2.setParameterValue(n3, parameter.getParameterValue(n3));
                }
            } else {
                Arrays.fill(this.virusLocationChanged, true);
                if (this.tipTraitsParameter != null) {
                    for (int i = 0; i < this.virusLocationsParameter.getParameterCount(); ++i) {
                        Parameter parameter = this.virusLocationsParameter.getParameter(i);
                        Parameter parameter3 = this.tipTraitsParameter.getParameter(this.tipIndices[i]);
                        for (int j = 0; j < parameter3.getDimension(); ++j) {
                            parameter3.setParameterValueQuietly(j, parameter.getParameterValue(j));
                        }
                    }
                    this.tipTraitsParameter.fireParameterChangedEvent();
                }
            }
        } else if (variable == this.serumLocationsParameter) {
            int n4 = n / this.mdsDimension;
            this.serumLocationChanged[n4] = true;
        } else if (variable == this.mdsPrecisionParameter) {
            this.setLocationChangedFlags(true);
        } else if (variable == this.locationDriftParameter) {
            this.setLocationChangedFlags(true);
        } else if (variable == this.virusDriftParameter) {
            this.setLocationChangedFlags(true);
        } else if (variable == this.serumDriftParameter) {
            this.setLocationChangedFlags(true);
        } else if (variable == this.serumPotenciesParameter) {
            this.serumEffectChanged[n] = true;
        } else if (variable == this.serumBreadthsParameter) {
            this.serumEffectChanged[n] = true;
        } else if (variable == this.virusAviditiesParameter) {
            this.virusEffectChanged[n] = true;
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.logLikelihoods, 0, this.storedLogLikelihoods, 0, this.logLikelihoods.length);
    }

    @Override
    protected void restoreState() {
        double[] dArray = this.logLikelihoods;
        this.logLikelihoods = this.storedLogLikelihoods;
        this.storedLogLikelihoods = dArray;
        this.likelihoodKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihood();
        }
        return this.logLikelihood;
    }

    private double computeLogLikelihood() {
        double d = this.mdsPrecisionParameter.getParameterValue(0);
        double d2 = 1.0 / Math.sqrt(d);
        this.logLikelihood = 0.0;
        int n = 0;
        for (Measurement measurement : this.measurements) {
            if (this.virusLocationChanged[measurement.virus] || this.serumLocationChanged[measurement.serum] || this.virusEffectChanged[measurement.virus] || this.serumEffectChanged[measurement.serum]) {
                double d3 = this.calculateBaseline(measurement.virus, measurement.serum) - this.computeDistance(measurement.virus, measurement.serum);
                switch (measurement.type) {
                    case INTERVAL: {
                        double d4 = measurement.log2Titre;
                        double d5 = measurement.log2Titre + this.intervalWidth;
                        this.logLikelihoods[n] = AntigenicLikelihood.computeMeasurementIntervalLikelihood(d4, d5, d3, d2);
                        break;
                    }
                    case POINT: {
                        this.logLikelihoods[n] = AntigenicLikelihood.computeMeasurementLikelihood(measurement.log2Titre, d3, d2);
                        break;
                    }
                    case THRESHOLD: {
                        if (measurement.isLowerThreshold) {
                            this.logLikelihoods[n] = AntigenicLikelihood.computeMeasurementThresholdLikelihood(measurement.log2Titre, d3, d2);
                            break;
                        }
                        this.logLikelihoods[n] = AntigenicLikelihood.computeMeasurementUpperThresholdLikelihood(measurement.log2Titre, d3, d2);
                        break;
                    }
                }
            }
            this.logLikelihood += this.logLikelihoods[n];
            ++n;
        }
        this.likelihoodKnown = true;
        this.setLocationChangedFlags(false);
        this.setSerumEffectChangedFlags(false);
        this.setVirusEffectChangedFlags(false);
        return this.logLikelihood;
    }

    private void setLocationChangedFlags(boolean bl) {
        int n;
        for (n = 0; n < this.virusLocationChanged.length; ++n) {
            this.virusLocationChanged[n] = bl;
        }
        for (n = 0; n < this.serumLocationChanged.length; ++n) {
            this.serumLocationChanged[n] = bl;
        }
    }

    private void setSerumEffectChangedFlags(boolean bl) {
        for (int i = 0; i < this.serumEffectChanged.length; ++i) {
            this.serumEffectChanged[i] = bl;
        }
    }

    private void setVirusEffectChangedFlags(boolean bl) {
        for (int i = 0; i < this.virusEffectChanged.length; ++i) {
            this.virusEffectChanged[i] = bl;
        }
    }

    protected double computeDistance(int n, int n2) {
        Parameter parameter = this.virusLocationsParameter.getParameter(n);
        Parameter parameter2 = this.serumLocationsParameter.getParameter(n2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.locationDriftParameter != null && this.virusOffsetsParameter != null && this.serumOffsetsParameter != null) {
            d2 = this.locationDriftParameter.getParameterValue(0) * this.virusOffsetsParameter.getParameterValue(n);
            d3 = this.locationDriftParameter.getParameterValue(0) * this.serumOffsetsParameter.getParameterValue(n2);
        }
        if (this.virusDriftParameter != null && this.virusOffsetsParameter != null) {
            d2 = this.virusDriftParameter.getParameterValue(0) * this.virusOffsetsParameter.getParameterValue(n);
        }
        if (this.serumDriftParameter != null && this.serumOffsetsParameter != null) {
            d3 = this.serumDriftParameter.getParameterValue(0) * this.serumOffsetsParameter.getParameterValue(n2);
        }
        double d4 = parameter.getParameterValue(0) + d2;
        double d5 = parameter2.getParameterValue(0) + d3;
        double d6 = d4 - d5;
        d += d6 * d6;
        for (int i = 1; i < this.mdsDimension; ++i) {
            d6 = parameter.getParameterValue(i) - parameter2.getParameterValue(i);
            d += d6 * d6;
        }
        double d7 = Math.sqrt(d);
        if (this.serumBreadthsParameter != null) {
            double d8 = this.serumBreadthsParameter.getParameterValue(n2);
            d7 /= d8;
        }
        return d7;
    }

    private double calculateBaseline(int n, int n2) {
        double d = this.serumPotenciesParameter.getParameterValue(n2);
        if (this.virusAviditiesParameter != null) {
            d += this.virusAviditiesParameter.getParameterValue(n);
        }
        return d;
    }

    private static double computeMeasurementLikelihood(double d, double d2, double d3) {
        double d4 = NormalDistribution.logPdf(d, d2, d3);
        if (Double.isInfinite(d4)) {
            throw new RuntimeException("infinite point measurement");
        }
        return d4;
    }

    private static double computeMeasurementThresholdLikelihood(double d, double d2, double d3) {
        double d4 = NormalDistribution.cdf(d, d2, d3, true);
        if (Double.isInfinite(d4)) {
            throw new RuntimeException("infinite threshold measurement");
        }
        return d4;
    }

    private static double computeMeasurementUpperThresholdLikelihood(double d, double d2, double d3) {
        double d4 = NormalDistribution.cdf(d, d2, d3, false);
        double d5 = Math.log(1.0 - d4);
        if (Double.isInfinite(d5)) {
            throw new RuntimeException("infinite threshold measurement");
        }
        return d5;
    }

    private static double computeMeasurementIntervalLikelihood(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = NormalDistribution.cdf(d2, d3, d4, true);
        double d7 = LogTricks.logDiff(d6, d5 = NormalDistribution.cdf(d, d3, d4, true));
        if (Double.isInfinite(d7) && Double.isInfinite(d7 = NormalDistribution.logPdf(d, d3, d4))) {
            throw new RuntimeException("infinite interval measurement");
        }
        return d7;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.setLocationChangedFlags(true);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Bayesian Antigenic Cartography framework";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(CommonCitations.BEDFORD_2015_INTEGRATING);
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0};
        System.out.println("titre\tpoint\tinterval(tail)\tinterval(cdf)\tthreshold");
        for (double d : dArray) {
            double d2 = AntigenicLikelihood.computeMeasurementLikelihood(d, 0.0, 1.0);
            double d3 = AntigenicLikelihood.computeMeasurementIntervalLikelihood(d + 1.0, d, 0.0, 1.0);
            double d4 = AntigenicLikelihood.computeMeasurementThresholdLikelihood(d, 0.0, 1.0);
            System.out.println(d + "\t" + d2 + "\t" + d3 + "\t" + d4);
        }
    }

    private class Measurement {
        final int virus;
        final int serum;
        final double virusDate;
        final double serumDate;
        final MeasurementType type;
        final double titre;
        final double log2Titre;
        final boolean isLowerThreshold;

        private Measurement(int n, int n2, double d, double d2, MeasurementType measurementType, double d3, boolean bl) {
            this.virus = n;
            this.serum = n2;
            this.virusDate = d;
            this.serumDate = d2;
            this.type = measurementType;
            this.titre = d3;
            this.log2Titre = Math.log(d3) / Math.log(2.0);
            this.isLowerThreshold = bl;
        }
    }

    public static enum MeasurementType {
        INTERVAL,
        POINT,
        THRESHOLD,
        MISSING;

    }
}

