/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;
import dr.inference.loggers.MLLogger;
import dr.inference.loggers.TabDelimitedFormatter;
import dr.inferencexml.loggers.LoggerParser;
import dr.xml.AttributeRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class TreeSummary
extends MCLogger {
    public static final String LOG_TREE = "TreeSummary";
    public static final String OUTPUT_FILE_NAME = "file";
    public static final String CHECK_EVERY = "checkEvery";
    private Tree tree = null;
    private HashMap<String, Integer> taxa = null;
    private HashMap<String, Integer> treeOccurences = null;
    private String outputFilename;
    public static XMLObjectParser PARSER = new LoggerParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("file", "name of a tree log file", "ds.trees"), AttributeRule.newIntegerRule("checkEvery", true)};

        public String getParserName() {
            return TreeSummary.LOG_TREE;
        }

        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute(TreeSummary.OUTPUT_FILE_NAME);
            int n = 1;
            if (xMLObject.hasAttribute(TreeSummary.CHECK_EVERY)) {
                n = xMLObject.getIntegerAttribute(TreeSummary.CHECK_EVERY);
            }
            Tree tree = (Tree)xMLObject.getChild(Tree.class);
            PrintWriter printWriter = 1.getLogFile((XMLObject)xMLObject, (String)this.getParserName());
            TabDelimitedFormatter tabDelimitedFormatter = new TabDelimitedFormatter(printWriter);
            return new TreeSummary(tree, tabDelimitedFormatter, n, string);
        }

        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        public String getParserDescription() {
            return "Calculates the tree probabilities on the flow.";
        }

        public String getExample() {
            return "<!-- The " + this.getParserName() + " element takes a treeModel to be logged -->\n<" + this.getParserName() + " " + "logEvery" + "=\"100\" " + TreeSummary.OUTPUT_FILE_NAME + "=\"log.trees\" \t<treeModel idref=\"treeModel1\"/>\n</" + this.getParserName() + ">\n";
        }

        public Class getReturnType() {
            return MLLogger.class;
        }
    };

    public TreeSummary(Tree tree, LogFormatter logFormatter, int n, String string) {
        super(logFormatter, n, false);
        this.tree = tree;
        this.outputFilename = string;
        this.treeOccurences = new HashMap();
    }

    @Override
    public void startLogging() {
        File file = new File(this.outputFilename);
        if (file.exists()) {
            file.delete();
        }
    }

    private HashMap<String, Integer> getTaxa() {
        int n = this.tree.getTaxonCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.tree.getTaxonId(i));
        }
        Collections.sort(arrayList);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 1; i <= n; ++i) {
            hashMap.put((String)arrayList.get(i - 1), i);
        }
        return hashMap;
    }

    @Override
    public void log(long l) {
        if (this.logEvery <= 0L || l % this.logEvery == 0L) {
            if (l == 0L) {
                this.taxa = this.getTaxa();
            }
            this.addTree(this.tree);
        }
    }

    private void addTree(Tree tree) {
        String string = TreeUtils.uniqueNewick(tree, tree.getRoot());
        if (this.treeOccurences.containsKey(string = this.replaceTaxa(string))) {
            this.treeOccurences.put(string, this.treeOccurences.get(string) + 1);
        } else {
            this.treeOccurences.put(string, 1);
        }
    }

    private String replaceTaxa(String string) {
        String string2 = string;
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            int n2;
            String string3;
            int n3;
            char c = string2.charAt(i);
            if (c == '(') {
                n = i + 1;
                continue;
            }
            if (c == ')') {
                n3 = i;
                if (n3 - n > 0) {
                    string3 = string2.substring(n, n3);
                    n2 = this.taxa.get(string3);
                    string2 = string2.substring(0, n) + n2 + string2.substring(n3);
                    i = n + (int)Math.log10(n2);
                }
                n = i + 1;
                continue;
            }
            if (c != ',') continue;
            n3 = i;
            if (n3 - n > 0) {
                string3 = string2.substring(n, n3);
                n2 = this.taxa.get(string3);
                string2 = string2.substring(0, n) + n2 + string2.substring(n3);
                i = n + (int)Math.log10(n2);
            }
            n = i + 1;
        }
        return string2;
    }

    @Override
    public void stopLogging() {
        this.printTrees();
        this.logLine("End;");
        super.stopLogging();
    }

    private void printTrees() {
        Set<String> set = this.treeOccurences.keySet();
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (String object : set) {
            arrayList.add(new Sample(object, this.treeOccurences.get(object)));
        }
        Collections.sort(arrayList);
        try {
            FileWriter fileWriter = new FileWriter(this.outputFilename);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("Taxa");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            Set<String> set2 = this.taxa.keySet();
            for (String string : set2) {
                int n = this.taxa.get(string);
                bufferedWriter.write(n + "\t=\t" + string);
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            for (Sample sample : arrayList) {
                bufferedWriter.write(sample.samples + "\t" + sample.tree);
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    class Sample
    implements Comparable<Sample> {
        String tree;
        int samples;

        public Sample(String string, int n) {
            this.tree = string;
            this.samples = n;
        }

        @Override
        public int compareTo(Sample sample) {
            return sample.samples - this.samples;
        }
    }
}

