/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class serumPrecisionSerumLocOperator
extends AbstractAdaptableOperator {
    private Parameter serumPrecision = null;
    private MatrixParameter serumLocations = null;
    private double scaleFactor;
    public static final String SERUMPRECSCALEALLSERUMLOC = "serumPrecScaleAllSerumLoc";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String SERUMLOCATIONS = "serumLocations";
        public static final String SERUMPREC = "serumPrec";
        public static final String SCALE = "scaleFactor";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("scaleFactor"), new ElementRule("serumLocations", Parameter.class), new ElementRule("serumPrec", Parameter.class)};

        @Override
        public String getParserName() {
            return serumPrecisionSerumLocOperator.SERUMPRECSCALEALLSERUMLOC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(SCALE);
            XMLObject xMLObject2 = xMLObject.getChild(SERUMLOCATIONS);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(SERUMPREC);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            return new serumPrecisionSerumLocOperator(d, matrixParameter, parameter, d2);
        }

        @Override
        public String getParserDescription() {
            return "changes serum drift and make sure the first dimension of the active drifted mus stay the same";
        }

        @Override
        public Class getReturnType() {
            return serumPrecisionSerumLocOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public serumPrecisionSerumLocOperator(double d, MatrixParameter matrixParameter, Parameter parameter, double d2) {
        super(AdaptationMode.ADAPTATION_ON);
        this.setWeight(d);
        this.serumLocations = matrixParameter;
        this.serumPrecision = parameter;
        this.scaleFactor = d2;
    }

    @Override
    public double doOperation() {
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        double d2 = this.serumPrecision.getParameterValue(0);
        double d3 = d * d2;
        this.serumPrecision.setParameterValue(0, d3);
        for (int i = 0; i < this.serumLocations.getColumnDimension(); ++i) {
            for (int j = 0; j < 2; ++j) {
                double d4 = this.serumLocations.getParameter(i).getParameterValue(j);
                double d5 = d4 * Math.sqrt(d2 / d3);
                this.serumLocations.getParameter(i).setParameterValue(j, d5);
            }
        }
        double d6 = -Math.log(d);
        return d6;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    @Override
    public final String getOperatorName() {
        return SERUMPRECSCALEALLSERUMLOC;
    }

    public int getStepCount() {
        return 1;
    }
}

