/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.LinkedList;

public class ClusterLabelsVirusesStatistic
extends Statistic.Abstract
implements VariableListener {
    private int max_dim;
    private LinkedList<Double> path = new LinkedList();
    private int[] clusterLabels;
    private Parameter indicators;
    private MatrixParameter virusLocations;
    private TreeModel treeModel;
    public static final String CLUSTERLABELS_STATISTIC = "clusterLabelsVirusesStatistic";
    int[] membershipToClusterLabelIndexes = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String INDICATORS = "indicators";
        public static final String MAXDIMSTR = "maxDim";
        public static final String VIRUSLOCATIONS = "virusLocations";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule("indicators", Parameter.class), new ElementRule("virusLocations", Parameter.class), AttributeRule.newDoubleRule("maxDim", true, "the variance of mu")};

        @Override
        public String getParserName() {
            return ClusterLabelsVirusesStatistic.CLUSTERLABELS_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(INDICATORS);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(VIRUSLOCATIONS);
            int n = 30;
            if (xMLObject.hasAttribute(MAXDIMSTR)) {
                n = xMLObject.getIntegerAttribute(MAXDIMSTR);
            }
            return new ClusterLabelsVirusesStatistic(treeModel, parameter, n, matrixParameter);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return ClusterLabelsVirusesStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ClusterLabelsVirusesStatistic(TreeModel treeModel, Parameter parameter, int n, MatrixParameter matrixParameter) {
        this.treeModel = treeModel;
        this.indicators = parameter;
        this.max_dim = n;
        this.virusLocations = matrixParameter;
        parameter.addParameterListener(this);
        this.virusLocations.addParameterListener(this);
        this.setMembershipToClusterLabelIndexes();
    }

    @Override
    public int getDimension() {
        int n = this.virusLocations.getColumnDimension();
        return n;
    }

    @Override
    public double getStatisticValue(int n) {
        if (n == 0) {
            this.setClusterLabelsUsingIndicators();
        }
        return this.clusterLabels[n];
    }

    private void setMembershipToClusterLabelIndexes() {
        int n = this.virusLocations.getColumnDimension();
        int n2 = this.treeModel.getNodeCount();
        this.membershipToClusterLabelIndexes = new int[n];
        this.clusterLabels = new int[n];
        for (int i = 0; i < n; ++i) {
            Parameter parameter = this.virusLocations.getParameter(i);
            String string = parameter.getParameterName();
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                String string2 = this.treeModel.getTaxonId(j);
                if (!string.equals(string2)) continue;
                this.membershipToClusterLabelIndexes[i] = j;
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("not found. Exit now.");
            System.exit(0);
        }
    }

    private void setClusterLabelsUsingIndicators() {
        int[] nArray = this.determine_membership_v2(this.treeModel);
        int n = this.virusLocations.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            this.clusterLabels[i] = nArray[this.membershipToClusterLabelIndexes[i]];
        }
    }

    int[] determine_membership_v2(TreeModel treeModel) {
        NodeRef nodeRef = treeModel.getRoot();
        int n = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray[i] = -1;
        }
        nArray[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                nArray[nodeRef2.getNumber()] = (int)this.indicators.getParameterValue(nodeRef2.getNumber()) == 1 ? ++n - 1 : nArray[treeModel.getParent(nodeRef2).getNumber()];
            }
            string = string + " cluster = " + nArray[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray;
    }

    int[] determine_from_membership_v2(TreeModel treeModel) {
        int[] nArray = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray[i] = -1;
        }
        NodeRef nodeRef = treeModel.getRoot();
        int n = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                if ((int)this.indicators.getParameterValue(nodeRef2.getNumber()) == 1) {
                    nArray2[nodeRef2.getNumber()] = ++n - 1;
                    nArray[n - 1] = nArray2[treeModel.getParent(nodeRef2).getNumber()];
                } else {
                    nArray2[nodeRef2.getNumber()] = nArray2[treeModel.getParent(nodeRef2).getNumber()];
                }
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray;
    }

    @Override
    public String getDimensionName(int n) {
        Parameter parameter = this.virusLocations.getParameter(n);
        String string = parameter.getParameterName();
        return string;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

