/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.operators;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.BayesianSkylineLikelihood;
import dr.evomodel.coalescent.OldAbstractCoalescentLikelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.ExponentialDistribution;
import dr.math.distributions.GammaDistribution;

@Deprecated
public class BayesianSkylineGibbsOperator
extends SimpleMCMCOperator {
    public static final int STEPWISE_TYPE = 0;
    public static final int LINEAR_TYPE = 1;
    public static final int EXPONENTIAL_TYPE = 2;
    private BayesianSkylineLikelihood bayesianSkylineLikelihood;
    private Parameter populationSizeParameter;
    private Parameter groupSizeParameter;
    private double upperBound;
    private double lowerBound;
    private boolean jeffreysGeometricPrior;
    private boolean jeffreysPrior;
    private boolean exponentialMarkovPrior;
    private double shape;
    private boolean reverse;
    private int iterations;

    public double getTargetAcceptanceProbability() {
        return 1.0;
    }

    public double getMinimumAcceptanceLevel() {
        return 0.99;
    }

    public double getMaximumAcceptanceLevel() {
        return 1.01;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.99;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 1.01;
    }

    public BayesianSkylineGibbsOperator(BayesianSkylineLikelihood bayesianSkylineLikelihood, Parameter parameter, Parameter parameter2, int n, double d, double d2, double d3, boolean bl, boolean bl2, double d4, boolean bl3, int n2) {
        this.bayesianSkylineLikelihood = bayesianSkylineLikelihood;
        this.populationSizeParameter = parameter;
        this.groupSizeParameter = parameter2;
        this.setWeight(d);
        this.lowerBound = d2;
        this.upperBound = d3;
        this.exponentialMarkovPrior = bl2;
        this.shape = d4;
        this.iterations = n2;
        if (bl2) {
            this.jeffreysPrior = bl;
            this.jeffreysGeometricPrior = false;
        } else {
            this.jeffreysGeometricPrior = bl;
            this.jeffreysPrior = false;
        }
        this.reverse = bl3;
        assert (parameter != null);
        assert (parameter2 != null);
        assert (parameter.getDimension() == parameter2.getDimension());
        assert (n2 >= 1);
        assert (d2 < d3);
        if (n != 0) {
            throw new IllegalArgumentException("Should only get stepwise type here - sorry.");
        }
        System.out.println("Using a Bayesian skyline Gibbs operator (lo=" + d2 + ", hi=" + d3 + ", Jeffreys=" + bl + ", exponentialMarkov=" + bl2 + " (shape=" + d4 + "), reverse=" + bl3 + ", iterations=" + n2 + ")");
    }

    public final String getPerformanceSuggestion() {
        return "";
    }

    double getSample(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        double d;
        int n2 = dArray3.length;
        int n3 = this.reverse ? -1 : 1;
        int n4 = this.reverse ? n2 - 1 : 0;
        int n5 = this.reverse ? 0 : n2 - 1;
        double d2 = dArray[n];
        double d3 = dArray2[n];
        double d4 = 0.0;
        if (this.jeffreysGeometricPrior) {
            d2 += 1.0 / (double)n2;
        }
        if (this.jeffreysPrior && n == n4) {
            d2 += 1.0;
        }
        if (this.exponentialMarkovPrior && n != n4) {
            d4 = dArray3[n - n3] / this.shape;
            d2 += 1.0 - this.shape;
        }
        if (this.exponentialMarkovPrior && n != n5) {
            d2 += this.shape;
            d3 += dArray3[n + n3] * this.shape;
        }
        int n6 = 0;
        while (((d = d4 > 0.0 ? 1.0 / GammaDistribution.nextExpGamma(d2 - 1.0, 1.0 / d3, d4) : 1.0 / GammaDistribution.nextGamma(d2 - 1.0, 1.0 / d3)) < this.lowerBound || d > this.upperBound) && ++n6 < 100) {
        }
        if (n6 == 100) {
            return Double.NEGATIVE_INFINITY;
        }
        double d5 = -d2 * Math.log(dArray3[n]) - d3 / dArray3[n];
        double d6 = -d2 * Math.log(d) - d3 / d;
        if (d4 > 0.0) {
            d5 += ExponentialDistribution.logPdf(dArray3[n], 1.0 / d4);
            d6 += ExponentialDistribution.logPdf(d, 1.0 / d4);
        }
        dArray3[n] = d;
        return d5 - d6;
    }

    @Override
    public double doOperation() {
        int n;
        if (!this.bayesianSkylineLikelihood.getIntervalsKnown()) {
            this.bayesianSkylineLikelihood.setupIntervals();
        }
        assert (this.populationSizeParameter != null);
        assert (this.groupSizeParameter != null);
        int n2 = 0;
        int n3 = 0;
        int[] nArray = this.bayesianSkylineLikelihood.getGroupSizes();
        double[] dArray = this.bayesianSkylineLikelihood.getGroupHeights();
        ConstantPopulation constantPopulation = new ConstantPopulation(Units.Type.YEARS);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray2 = new double[nArray.length];
        double[] dArray3 = new double[nArray.length];
        double[] dArray4 = new double[nArray.length];
        for (int i = 0; i < this.bayesianSkylineLikelihood.getIntervalCount(); ++i) {
            double d4;
            dArray2[n2] = d4 = this.bayesianSkylineLikelihood.getPopSize(n2, d3 + this.bayesianSkylineLikelihood.getInterval(i) / 2.0, dArray);
            constantPopulation.setN0(d4);
            d += this.bayesianSkylineLikelihood.calculateIntervalShapeParameter(constantPopulation, this.bayesianSkylineLikelihood.getInterval(i), d3, this.bayesianSkylineLikelihood.getLineageCount(i), this.bayesianSkylineLikelihood.getIntervalType(i));
            d2 += this.bayesianSkylineLikelihood.calculateIntervalRateParameter(constantPopulation, this.bayesianSkylineLikelihood.getInterval(i), d3, this.bayesianSkylineLikelihood.getLineageCount(i), this.bayesianSkylineLikelihood.getIntervalType(i)) * d4;
            if (this.bayesianSkylineLikelihood.getIntervalType(i) == OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT && ++n3 >= nArray[n2]) {
                dArray3[n2] = d;
                dArray4[n2] = d2;
                d = 0.0;
                d2 = 0.0;
                ++n2;
                n3 = 0;
            }
            int n4 = this.bayesianSkylineLikelihood.getCoalescentEvents(i) - 1;
            for (n = 0; n < n4; ++n) {
                dArray2[n2] = d4 = this.bayesianSkylineLikelihood.getPopSize(n2, d3 + this.bayesianSkylineLikelihood.getInterval(i) / 2.0, dArray);
                constantPopulation.setN0(d4);
                d += this.bayesianSkylineLikelihood.calculateIntervalShapeParameter(constantPopulation, this.bayesianSkylineLikelihood.getInterval(i), d3, this.bayesianSkylineLikelihood.getLineageCount(i), this.bayesianSkylineLikelihood.getIntervalType(i));
                d2 += this.bayesianSkylineLikelihood.calculateIntervalRateParameter(constantPopulation, this.bayesianSkylineLikelihood.getInterval(i), d3, this.bayesianSkylineLikelihood.getLineageCount(i), this.bayesianSkylineLikelihood.getIntervalType(i)) * d4;
                if (++n3 < nArray[n2]) continue;
                dArray3[n2] = d;
                dArray4[n2] = d2;
                d = 0.0;
                d2 = 0.0;
                ++n2;
                n3 = 0;
            }
            d3 += this.bayesianSkylineLikelihood.getInterval(i);
        }
        double d5 = 0.0;
        int n5 = this.iterations;
        boolean[] blArray = new boolean[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            blArray[n] = false;
        }
        while (n5 > 0) {
            n = MathUtils.nextInt(nArray.length);
            if (!blArray[n]) {
                d5 += this.getSample(dArray3, dArray4, dArray2, n);
                blArray[n] = true;
                if (n != 0) {
                    blArray[n - 1] = false;
                }
                if (n != nArray.length - 1) {
                    blArray[n + 1] = false;
                }
            }
            --n5;
        }
        for (n = 0; n < n2; ++n) {
            this.populationSizeParameter.setParameterValue(n, dArray2[n]);
        }
        return d5;
    }

    @Override
    public final String getOperatorName() {
        return "generalizedSkylineGibbsOperator";
    }
}

