/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.LUPDecomposition;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;

public class Matrix {
    protected double[][] components;
    protected LUPDecomposition lupDecomposition = null;

    public Matrix(double[][] dArray) {
        this.components = dArray;
    }

    public Matrix(double[] dArray, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new NegativeArraySizeException("Requested matrix size: " + n + " by " + n2);
        }
        if (n * n2 != dArray.length) {
            throw new IllegalArgumentException("Requested matrix size: " + n + " by " + n2 + " doesn't match array size: " + dArray.length);
        }
        this.components = new double[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.components[i][j] = dArray[n3];
                ++n3;
            }
        }
    }

    public Matrix(int n, int n2) throws NegativeArraySizeException {
        if (n <= 0 || n2 <= 0) {
            throw new NegativeArraySizeException("Requested matrix size: " + n + " by " + n2);
        }
        this.components = new double[n][n2];
    }

    public Matrix clone() {
        return new Matrix((double[][])this.components.clone());
    }

    public void accumulate(Matrix matrix) throws IllegalDimension {
        if (matrix.rows() != this.rows() || matrix.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot add a" + matrix.rows() + " by " + matrix.columns() + " matrix to a " + this.rows() + " by " + this.columns() + " matrix");
        }
        int n = this.components[0].length;
        for (int i = 0; i < this.components.length; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray = this.components[i];
                int n2 = j;
                dArray[n2] = dArray[n2] + matrix.component(i, j);
            }
        }
    }

    public void decumulate(Matrix matrix) throws IllegalDimension {
        if (matrix.rows() != this.rows() || matrix.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot add a" + matrix.rows() + " by " + matrix.columns() + " matrix to a " + this.rows() + " by " + this.columns() + " matrix");
        }
        int n = this.components[0].length;
        for (int i = 0; i < this.components.length; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray = this.components[i];
                int n2 = j;
                dArray[n2] = dArray[n2] - matrix.component(i, j);
            }
        }
    }

    public Matrix add(Matrix matrix) throws IllegalDimension {
        if (matrix.rows() != this.rows() || matrix.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot add a " + matrix.rows() + " by " + matrix.columns() + " matrix to a " + this.rows() + " by " + this.columns() + " matrix");
        }
        return new Matrix(this.addComponents(matrix));
    }

    protected double[][] addComponents(Matrix matrix) {
        int n = this.rows();
        int n2 = this.columns();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = this.components[i][j] + matrix.components[i][j];
            }
        }
        return dArray;
    }

    public void clear() {
        int n = this.components[0].length;
        for (int i = 0; i < this.components.length; ++i) {
            for (int j = 0; j < n; ++j) {
                this.components[i][j] = 0.0;
            }
        }
    }

    public int columns() {
        return this.components[0].length;
    }

    public double component(int n, int n2) {
        return this.components[n][n2];
    }

    public void set(int n, int n2, double d) {
        this.components[n][n2] = d;
    }

    public double determinant() throws IllegalDimension {
        return this.lupDecomposition().determinant();
    }

    public double logDeterminant() throws IllegalDimension {
        return this.lupDecomposition().logDeterminant();
    }

    public boolean isPD() throws IllegalDimension {
        return this.lupDecomposition().isPD();
    }

    public boolean equals(Matrix matrix) {
        int n = this.rows();
        if (matrix.rows() != n) {
            return false;
        }
        int n2 = this.columns();
        if (matrix.columns() != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (matrix.components[i][j] == this.components[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix inverse() throws ArithmeticException {
        try {
            return new Matrix(this.lupDecomposition().inverseMatrixComponents());
        }
        catch (IllegalDimension illegalDimension) {
            return new Matrix(this.transposedProduct().inverse().productWithTransposedComponents(this));
        }
    }

    public boolean isSquare() {
        return this.rows() == this.columns();
    }

    protected LUPDecomposition lupDecomposition() throws IllegalDimension {
        if (this.lupDecomposition == null) {
            this.lupDecomposition = new LUPDecomposition(this);
        }
        return this.lupDecomposition;
    }

    public Matrix product(double d) {
        return new Matrix(this.productComponents(d));
    }

    public Vector product(Vector vector) throws IllegalDimension {
        int n = this.rows();
        int n2 = this.columns();
        if (vector.dimension() != n2) {
            throw new IllegalDimension("Product error: " + n + " by " + n2 + " matrix cannot by multiplied with vector of dimension " + vector.dimension());
        }
        return this.secureProduct(vector);
    }

    public Matrix product(Matrix matrix) throws IllegalDimension {
        if (matrix.rows() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot multiply a " + this.rows() + " by " + this.columns() + " matrix with a " + matrix.rows() + " by " + matrix.columns() + " matrix");
        }
        return new Matrix(this.productComponents(matrix));
    }

    protected double[][] productComponents(double d) {
        int n = this.rows();
        int n2 = this.columns();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = d * this.components[i][j];
            }
        }
        return dArray;
    }

    protected double[][] productComponents(Matrix matrix) {
        int n = this.columns();
        int n2 = this.rows();
        int n3 = matrix.columns();
        double[][] dArray = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.components[i][k] * matrix.components[k][j];
                }
                dArray[i][j] = d;
            }
        }
        return dArray;
    }

    public Matrix productWithTransposed(Matrix matrix) throws IllegalDimension {
        if (matrix.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot multiply a " + this.rows() + " by " + this.columns() + " matrix with the transpose of a " + matrix.rows() + " by " + matrix.columns() + " matrix");
        }
        return new Matrix(this.productWithTransposedComponents(matrix));
    }

    public static Matrix buildIdentityTimesElementMatrix(int n, double d) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = d;
        }
        return new Matrix(dArray);
    }

    protected double[][] productWithTransposedComponents(Matrix matrix) {
        int n = this.columns();
        int n2 = this.rows();
        int n3 = matrix.rows();
        double[][] dArray = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.components[i][k] * matrix.components[j][k];
                }
                dArray[i][j] = d;
            }
        }
        return dArray;
    }

    public int rows() {
        return this.components.length;
    }

    protected Vector secureProduct(Vector vector) {
        int n = this.rows();
        int n2 = this.columns();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                dArray[n3] = dArray[n3] + this.components[i][j] * vector.components[j];
            }
        }
        return new Vector(dArray);
    }

    protected Matrix secureProduct(Matrix matrix) {
        return new Matrix(this.productComponents(matrix));
    }

    protected Matrix secureSubtract(Matrix matrix) {
        return new Matrix(this.subtractComponents(matrix));
    }

    public Matrix subtract(Matrix matrix) throws IllegalDimension {
        if (matrix.rows() != this.rows() || matrix.columns() != this.columns()) {
            throw new IllegalDimension("Product error: cannot subtract a" + matrix.rows() + " by " + matrix.columns() + " matrix to a " + this.rows() + " by " + this.columns() + " matrix");
        }
        return new Matrix(this.subtractComponents(matrix));
    }

    protected double[][] subtractComponents(Matrix matrix) {
        int n = this.rows();
        int n2 = this.columns();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.components[i][j] - matrix.components[i][j];
            }
        }
        return dArray;
    }

    public double[][] toComponents() {
        int n = this.rows();
        int n2 = this.columns();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.components[i][j];
            }
        }
        return dArray;
    }

    public double[] toArrayComponents() {
        int n = this.rows();
        int n2 = this.columns();
        double[] dArray = new double[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[n3] = this.components[i][j];
                ++n3;
            }
        }
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'[', ' '};
        int n = this.rows();
        int n2 = this.columns();
        for (int i = 0; i < n; ++i) {
            cArray[0] = 123;
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(cArray);
                stringBuffer.append(this.components[i][j]);
                cArray[0] = 32;
            }
            stringBuffer.append('}');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String toStringOctave() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.rows();
        int n2 = this.columns();
        stringBuffer.append("[ ");
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(this.components[i][j]);
                if (j == n2 - 1) {
                    if (i == n - 1) {
                        stringBuffer.append(" ");
                        continue;
                    }
                    stringBuffer.append("; ");
                    continue;
                }
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Matrix transpose() {
        int n = this.rows();
        int n2 = this.columns();
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j][i] = this.components[i][j];
            }
        }
        return new Matrix(dArray);
    }

    public Matrix extractRowsAndColumns(int[] nArray, int[] nArray2) {
        return new Matrix(Matrix.gatherRowsAndColumns(this.components, nArray, nArray2));
    }

    public SymmetricMatrix transposedProduct() {
        return new SymmetricMatrix(this.transposedProductComponents(this));
    }

    public Matrix transposedProduct(Matrix matrix) throws IllegalDimension {
        if (matrix.rows() != this.rows()) {
            throw new IllegalDimension("Operation error: cannot multiply a tranposed " + this.rows() + " by " + this.columns() + " matrix with a " + matrix.rows() + " by " + matrix.columns() + " matrix");
        }
        return new Matrix(this.transposedProductComponents(matrix));
    }

    protected double[][] transposedProductComponents(Matrix matrix) {
        int n = this.rows();
        int n2 = this.columns();
        int n3 = matrix.columns();
        double[][] dArray = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.components[k][i] * matrix.components[k][j];
                }
                dArray[i][j] = d;
            }
        }
        return dArray;
    }

    public static double[][] gatherRowsAndColumns(double[][] dArray, int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[nArray[i]];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray3[nArray2[j]];
            }
        }
        return dArray2;
    }

    public static double[] gatherEntries(double[] dArray, int[] nArray) {
        int n = nArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[nArray[i]];
        }
        return dArray2;
    }
}

